{
 "cells": [
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "# Matplot Lib"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "### Importing Libraries"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 2,
   "metadata": {},
   "outputs": [],
   "source": [
    "import matplotlib.pyplot as plt\n",
    "import numpy as np\n",
    "import pandas as pd "
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "### Basic Graph"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 28,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "# plot(x, y)\n",
    "# plt.plot([1, 2, 3], [6, 4, 5])\n",
    "\n",
    "x=[400, 500, 300, 200, 350]\n",
    "y=[5.67, -5.6, -4, 4, 9]\n",
    "\n",
    "# plt.plot(x, y)\n",
    "\n",
    "# Making graph a bit fancy\n",
    "plt.plot(x, y, label='Linear', color='cyan', marker='.', linestyle='--', markersize=10, markeredgecolor='red')\n",
    "\n",
    "#labels\n",
    "plt.title('Basic Graph')\n",
    "plt.xlabel('X Axis')\n",
    "plt.ylabel('Y Axis')\n",
    "\n",
    "plt.legend() # Add a legend\n",
    "\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 36,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "# multiple plots in 1 graph\n",
    "plt.plot([0, 1, 2, 3, 4], [0, 2, 4, 6, 8],'b^--', label='2x') #linear graph y=2x\n",
    "\n",
    "# 2nd Line\n",
    "x = np.arange(0, 4.5, 0.5) # creates array range 0-4.5 with interval of 0.5\n",
    "# print(x)\n",
    "plt.plot(x, x**2, 'r', label='x^2') # y=x^2\n",
    "\n",
    "plt.legend()\n",
    "# plt.savefig('Linear-Poly.png') #save graph as image in current directory\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "### Bar Chart"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 42,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "labels = ['A', 'B', 'C']\n",
    "values = [1,4,2]\n",
    "\n",
    "plt.bar(labels, values)\n",
    "\n",
    "plt.show() "
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "### Histogram"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 49,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "\n",
    "data = [20, 60, 20, 20, 40, 40, 30 ,40, 60]\n",
    "plt.hist( data)\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "## Let's play with real world data"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 41,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/html": [
       "<div>\n",
       "<style scoped>\n",
       "    .dataframe tbody tr th:only-of-type {\n",
       "        vertical-align: middle;\n",
       "    }\n",
       "\n",
       "    .dataframe tbody tr th {\n",
       "        vertical-align: top;\n",
       "    }\n",
       "\n",
       "    .dataframe thead th {\n",
       "        text-align: right;\n",
       "    }\n",
       "</style>\n",
       "<table border=\"1\" class=\"dataframe\">\n",
       "  <thead>\n",
       "    <tr style=\"text-align: right;\">\n",
       "      <th></th>\n",
       "      <th>Unnamed: 0</th>\n",
       "      <th>ID</th>\n",
       "      <th>Name</th>\n",
       "      <th>Age</th>\n",
       "      <th>Photo</th>\n",
       "      <th>Nationality</th>\n",
       "      <th>Flag</th>\n",
       "      <th>Overall</th>\n",
       "      <th>Potential</th>\n",
       "      <th>Club</th>\n",
       "      <th>...</th>\n",
       "      <th>Composure</th>\n",
       "      <th>Marking</th>\n",
       "      <th>StandingTackle</th>\n",
       "      <th>SlidingTackle</th>\n",
       "      <th>GKDiving</th>\n",
       "      <th>GKHandling</th>\n",
       "      <th>GKKicking</th>\n",
       "      <th>GKPositioning</th>\n",
       "      <th>GKReflexes</th>\n",
       "      <th>Release Clause</th>\n",
       "    </tr>\n",
       "  </thead>\n",
       "  <tbody>\n",
       "    <tr>\n",
       "      <th>0</th>\n",
       "      <td>0</td>\n",
       "      <td>158023</td>\n",
       "      <td>L. Messi</td>\n",
       "      <td>31</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/158023.png</td>\n",
       "      <td>Argentina</td>\n",
       "      <td>https://cdn.sofifa.org/flags/52.png</td>\n",
       "      <td>94</td>\n",
       "      <td>94</td>\n",
       "      <td>FC Barcelona</td>\n",
       "      <td>...</td>\n",
       "      <td>96.0</td>\n",
       "      <td>33.0</td>\n",
       "      <td>28.0</td>\n",
       "      <td>26.0</td>\n",
       "      <td>6.0</td>\n",
       "      <td>11.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>14.0</td>\n",
       "      <td>8.0</td>\n",
       "      <td>€226.5M</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>1</th>\n",
       "      <td>1</td>\n",
       "      <td>20801</td>\n",
       "      <td>Cristiano Ronaldo</td>\n",
       "      <td>33</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/20801.png</td>\n",
       "      <td>Portugal</td>\n",
       "      <td>https://cdn.sofifa.org/flags/38.png</td>\n",
       "      <td>94</td>\n",
       "      <td>94</td>\n",
       "      <td>Juventus</td>\n",
       "      <td>...</td>\n",
       "      <td>95.0</td>\n",
       "      <td>28.0</td>\n",
       "      <td>31.0</td>\n",
       "      <td>23.0</td>\n",
       "      <td>7.0</td>\n",
       "      <td>11.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>14.0</td>\n",
       "      <td>11.0</td>\n",
       "      <td>€127.1M</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>2</th>\n",
       "      <td>2</td>\n",
       "      <td>190871</td>\n",
       "      <td>Neymar Jr</td>\n",
       "      <td>26</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/190871.png</td>\n",
       "      <td>Brazil</td>\n",
       "      <td>https://cdn.sofifa.org/flags/54.png</td>\n",
       "      <td>92</td>\n",
       "      <td>93</td>\n",
       "      <td>Paris Saint-Germain</td>\n",
       "      <td>...</td>\n",
       "      <td>94.0</td>\n",
       "      <td>27.0</td>\n",
       "      <td>24.0</td>\n",
       "      <td>33.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>11.0</td>\n",
       "      <td>€228.1M</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>3</th>\n",
       "      <td>3</td>\n",
       "      <td>193080</td>\n",
       "      <td>De Gea</td>\n",
       "      <td>27</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/193080.png</td>\n",
       "      <td>Spain</td>\n",
       "      <td>https://cdn.sofifa.org/flags/45.png</td>\n",
       "      <td>91</td>\n",
       "      <td>93</td>\n",
       "      <td>Manchester United</td>\n",
       "      <td>...</td>\n",
       "      <td>68.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>21.0</td>\n",
       "      <td>13.0</td>\n",
       "      <td>90.0</td>\n",
       "      <td>85.0</td>\n",
       "      <td>87.0</td>\n",
       "      <td>88.0</td>\n",
       "      <td>94.0</td>\n",
       "      <td>€138.6M</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>4</th>\n",
       "      <td>4</td>\n",
       "      <td>192985</td>\n",
       "      <td>K. De Bruyne</td>\n",
       "      <td>27</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/192985.png</td>\n",
       "      <td>Belgium</td>\n",
       "      <td>https://cdn.sofifa.org/flags/7.png</td>\n",
       "      <td>91</td>\n",
       "      <td>92</td>\n",
       "      <td>Manchester City</td>\n",
       "      <td>...</td>\n",
       "      <td>88.0</td>\n",
       "      <td>68.0</td>\n",
       "      <td>58.0</td>\n",
       "      <td>51.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>13.0</td>\n",
       "      <td>5.0</td>\n",
       "      <td>10.0</td>\n",
       "      <td>13.0</td>\n",
       "      <td>€196.4M</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>...</th>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "      <td>...</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>18202</th>\n",
       "      <td>18202</td>\n",
       "      <td>238813</td>\n",
       "      <td>J. Lundstram</td>\n",
       "      <td>19</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/238813.png</td>\n",
       "      <td>England</td>\n",
       "      <td>https://cdn.sofifa.org/flags/14.png</td>\n",
       "      <td>47</td>\n",
       "      <td>65</td>\n",
       "      <td>Crewe Alexandra</td>\n",
       "      <td>...</td>\n",
       "      <td>45.0</td>\n",
       "      <td>40.0</td>\n",
       "      <td>48.0</td>\n",
       "      <td>47.0</td>\n",
       "      <td>10.0</td>\n",
       "      <td>13.0</td>\n",
       "      <td>7.0</td>\n",
       "      <td>8.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>€143K</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>18203</th>\n",
       "      <td>18203</td>\n",
       "      <td>243165</td>\n",
       "      <td>N. Christoffersson</td>\n",
       "      <td>19</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/243165.png</td>\n",
       "      <td>Sweden</td>\n",
       "      <td>https://cdn.sofifa.org/flags/46.png</td>\n",
       "      <td>47</td>\n",
       "      <td>63</td>\n",
       "      <td>Trelleborgs FF</td>\n",
       "      <td>...</td>\n",
       "      <td>42.0</td>\n",
       "      <td>22.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>19.0</td>\n",
       "      <td>10.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>5.0</td>\n",
       "      <td>12.0</td>\n",
       "      <td>€113K</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>18204</th>\n",
       "      <td>18204</td>\n",
       "      <td>241638</td>\n",
       "      <td>B. Worman</td>\n",
       "      <td>16</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/241638.png</td>\n",
       "      <td>England</td>\n",
       "      <td>https://cdn.sofifa.org/flags/14.png</td>\n",
       "      <td>47</td>\n",
       "      <td>67</td>\n",
       "      <td>Cambridge United</td>\n",
       "      <td>...</td>\n",
       "      <td>41.0</td>\n",
       "      <td>32.0</td>\n",
       "      <td>13.0</td>\n",
       "      <td>11.0</td>\n",
       "      <td>6.0</td>\n",
       "      <td>5.0</td>\n",
       "      <td>10.0</td>\n",
       "      <td>6.0</td>\n",
       "      <td>13.0</td>\n",
       "      <td>€165K</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>18205</th>\n",
       "      <td>18205</td>\n",
       "      <td>246268</td>\n",
       "      <td>D. Walker-Rice</td>\n",
       "      <td>17</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/246268.png</td>\n",
       "      <td>England</td>\n",
       "      <td>https://cdn.sofifa.org/flags/14.png</td>\n",
       "      <td>47</td>\n",
       "      <td>66</td>\n",
       "      <td>Tranmere Rovers</td>\n",
       "      <td>...</td>\n",
       "      <td>46.0</td>\n",
       "      <td>20.0</td>\n",
       "      <td>25.0</td>\n",
       "      <td>27.0</td>\n",
       "      <td>14.0</td>\n",
       "      <td>6.0</td>\n",
       "      <td>14.0</td>\n",
       "      <td>8.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>€143K</td>\n",
       "    </tr>\n",
       "    <tr>\n",
       "      <th>18206</th>\n",
       "      <td>18206</td>\n",
       "      <td>246269</td>\n",
       "      <td>G. Nugent</td>\n",
       "      <td>16</td>\n",
       "      <td>https://cdn.sofifa.org/players/4/19/246269.png</td>\n",
       "      <td>England</td>\n",
       "      <td>https://cdn.sofifa.org/flags/14.png</td>\n",
       "      <td>46</td>\n",
       "      <td>66</td>\n",
       "      <td>Tranmere Rovers</td>\n",
       "      <td>...</td>\n",
       "      <td>43.0</td>\n",
       "      <td>40.0</td>\n",
       "      <td>43.0</td>\n",
       "      <td>50.0</td>\n",
       "      <td>10.0</td>\n",
       "      <td>15.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>12.0</td>\n",
       "      <td>9.0</td>\n",
       "      <td>€165K</td>\n",
       "    </tr>\n",
       "  </tbody>\n",
       "</table>\n",
       "<p>18207 rows × 89 columns</p>\n",
       "</div>"
      ],
      "text/plain": [
       "       Unnamed: 0      ID                Name  Age  \\\n",
       "0               0  158023            L. Messi   31   \n",
       "1               1   20801   Cristiano Ronaldo   33   \n",
       "2               2  190871           Neymar Jr   26   \n",
       "3               3  193080              De Gea   27   \n",
       "4               4  192985        K. De Bruyne   27   \n",
       "...           ...     ...                 ...  ...   \n",
       "18202       18202  238813        J. Lundstram   19   \n",
       "18203       18203  243165  N. Christoffersson   19   \n",
       "18204       18204  241638           B. Worman   16   \n",
       "18205       18205  246268      D. Walker-Rice   17   \n",
       "18206       18206  246269           G. Nugent   16   \n",
       "\n",
       "                                                Photo Nationality  \\\n",
       "0      https://cdn.sofifa.org/players/4/19/158023.png   Argentina   \n",
       "1       https://cdn.sofifa.org/players/4/19/20801.png    Portugal   \n",
       "2      https://cdn.sofifa.org/players/4/19/190871.png      Brazil   \n",
       "3      https://cdn.sofifa.org/players/4/19/193080.png       Spain   \n",
       "4      https://cdn.sofifa.org/players/4/19/192985.png     Belgium   \n",
       "...                                               ...         ...   \n",
       "18202  https://cdn.sofifa.org/players/4/19/238813.png     England   \n",
       "18203  https://cdn.sofifa.org/players/4/19/243165.png      Sweden   \n",
       "18204  https://cdn.sofifa.org/players/4/19/241638.png     England   \n",
       "18205  https://cdn.sofifa.org/players/4/19/246268.png     England   \n",
       "18206  https://cdn.sofifa.org/players/4/19/246269.png     England   \n",
       "\n",
       "                                      Flag  Overall  Potential  \\\n",
       "0      https://cdn.sofifa.org/flags/52.png       94         94   \n",
       "1      https://cdn.sofifa.org/flags/38.png       94         94   \n",
       "2      https://cdn.sofifa.org/flags/54.png       92         93   \n",
       "3      https://cdn.sofifa.org/flags/45.png       91         93   \n",
       "4       https://cdn.sofifa.org/flags/7.png       91         92   \n",
       "...                                    ...      ...        ...   \n",
       "18202  https://cdn.sofifa.org/flags/14.png       47         65   \n",
       "18203  https://cdn.sofifa.org/flags/46.png       47         63   \n",
       "18204  https://cdn.sofifa.org/flags/14.png       47         67   \n",
       "18205  https://cdn.sofifa.org/flags/14.png       47         66   \n",
       "18206  https://cdn.sofifa.org/flags/14.png       46         66   \n",
       "\n",
       "                      Club  ... Composure Marking StandingTackle  \\\n",
       "0             FC Barcelona  ...      96.0    33.0           28.0   \n",
       "1                 Juventus  ...      95.0    28.0           31.0   \n",
       "2      Paris Saint-Germain  ...      94.0    27.0           24.0   \n",
       "3        Manchester United  ...      68.0    15.0           21.0   \n",
       "4          Manchester City  ...      88.0    68.0           58.0   \n",
       "...                    ...  ...       ...     ...            ...   \n",
       "18202      Crewe Alexandra  ...      45.0    40.0           48.0   \n",
       "18203       Trelleborgs FF  ...      42.0    22.0           15.0   \n",
       "18204     Cambridge United  ...      41.0    32.0           13.0   \n",
       "18205      Tranmere Rovers  ...      46.0    20.0           25.0   \n",
       "18206      Tranmere Rovers  ...      43.0    40.0           43.0   \n",
       "\n",
       "       SlidingTackle GKDiving  GKHandling  GKKicking  GKPositioning  \\\n",
       "0               26.0      6.0        11.0       15.0           14.0   \n",
       "1               23.0      7.0        11.0       15.0           14.0   \n",
       "2               33.0      9.0         9.0       15.0           15.0   \n",
       "3               13.0     90.0        85.0       87.0           88.0   \n",
       "4               51.0     15.0        13.0        5.0           10.0   \n",
       "...              ...      ...         ...        ...            ...   \n",
       "18202           47.0     10.0        13.0        7.0            8.0   \n",
       "18203           19.0     10.0         9.0        9.0            5.0   \n",
       "18204           11.0      6.0         5.0       10.0            6.0   \n",
       "18205           27.0     14.0         6.0       14.0            8.0   \n",
       "18206           50.0     10.0        15.0        9.0           12.0   \n",
       "\n",
       "      GKReflexes Release Clause  \n",
       "0            8.0        €226.5M  \n",
       "1           11.0        €127.1M  \n",
       "2           11.0        €228.1M  \n",
       "3           94.0        €138.6M  \n",
       "4           13.0        €196.4M  \n",
       "...          ...            ...  \n",
       "18202        9.0          €143K  \n",
       "18203       12.0          €113K  \n",
       "18204       13.0          €165K  \n",
       "18205        9.0          €143K  \n",
       "18206        9.0          €165K  \n",
       "\n",
       "[18207 rows x 89 columns]"
      ]
     },
     "execution_count": 41,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "## Load Fifa Data\n",
    "fifa = pd.read_csv('fifa_data.csv')\n",
    "\n",
    "# fifa = pd.read_csv('https://raw.githubusercontent.com/PEC-CSS/Open-Source/main/ML/EDA%20Workshop/fifa_data.csv')\n",
    "\n",
    "fifa"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "### Histograms"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 117,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "164"
      ]
     },
     "execution_count": 117,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "# creating list of unique countries\n",
    "countries = fifa['Nationality'].unique()\n",
    "countries.size"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 114,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "iVBORw0KGgoAAAANSUhEUgAABIoAAAHSCAYAAACD9CDIAAAAOXRFWHRTb2Z0d2FyZQBNYXRwbG90bGliIHZlcnNpb24zLjMuMywgaHR0cHM6Ly9tYXRwbG90bGliLm9yZy/Il7ecAAAACXBIWXMAAAsTAAALEwEAmpwYAABKpElEQVR4nO3dedxlR10n/k8lnYSELUBiUIIEMDoiKmIEXCcKKIsjOoP+YFQWceKC+zbBGYXXOGp0RlFcB4QBZhwUFSUCiogigiAkECAJWxMakpClk3TWTu/1+6OqOOe5uU93up8nveX9fr3u67n33LNU1alTp8731LlPqbUGAAAAAI451AkAAAAA4PAgUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0G041AnYm1NOOaWeccYZhzoZAAAAAEeNCy+88Lpa66nLvjusA0VnnHFGLrjggkOdDAAAAICjRinlU6t959EzAAAAAJIIFAEAAADQCRQBAAAAkESgCAAAAIBOoAgAAACAJAJFAAAAAHQCRQAAAAAkESgCAAAAoBMoAgAAACCJQBEAAAAAnUARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0AkUAQAAAJAk2XCoE8Dd1xnnvnHp9E3nPfUgpwQAAABIjCgCAAAAoBMoAgAAACCJQBEAAAAAnUARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0O0zUFRKeUUp5dpSysUL03+0lPKRUsolpZRfn01/QSllYynlo6WUb5lNf1KftrGUcu76ZgMAAACAtdpwJ+Z5ZZLfTfLqMaGU8o1Jnpbky2ut20spn9OnPyLJM5J8SZLPS/L3pZQv7Iv9XpInJrkiyXtLKefXWi9dr4wAAAAAsDb7DBTVWt9eSjljYfIPJTmv1rq9z3Ntn/60JH/Sp3+ylLIxyWP6dxtrrZclSSnlT/q8AkUAAAAAh4kD/Y2iL0zy9aWUfy2l/FMp5av69AcluXw23xV92mrTAQAAADhM3JlHz1Zb7v5JHpfkq5K8tpTysPVIUCnlnCTnJMnnf/7nr8cqAQAAALgTDnRE0RVJXleb9yTZk+SUJFcmefBsvtP7tNWm30Gt9aW11rNqrWedeuqpB5g8AAAAAPbXgQaK/irJNyZJ/7Hq45Ncl+T8JM8opZxQSnlokjOTvCfJe5OcWUp5aCnl+LQfvD5/jWkHAAAAYB3t89GzUsprkpyd5JRSyhVJXpjkFUleUUq5OMmOJM+utdYkl5RSXpv2I9W7kjy/1rq7r+dHkrw5ybFJXlFrveQuyA8AAAAAB+jO/NezZ67y1fesMv8vJ/nlJdPflORN+5U6AAAAAA6aA330DAAAAICjjEARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0AkUAQAAAJBEoAgAAACATqAIAAAAgCQCRQAAAAB0AkUAAAAAJBEoAgAAAKATKAIAAAAgiUARAAAAAJ1AEQAAAABJBIoAAAAA6ASKAAAAAEgiUAQAAABAJ1AEAAAAQBKBIgAAAAA6gSIAAAAAkggUAQAAANAJFAEAAACQRKAIAAAAgE6gCAAAAIAkAkUAAAAAdAJFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQCdQBAAAAEASgSIAAAAAOoEiAAAAAJIIFAEAAADQ7TNQVEp5RSnl2lLKxUu+++lSSi2lnNI/l1LKS0opG0spHyylPHo277NLKR/vr2evbzYAAAAAWKs7M6LolUmetDixlPLgJN+c5NOzyU9OcmZ/nZPkD/q890/ywiSPTfKYJC8spdxvLQkHAAAAYH3tM1BUa317khuWfPXiJD+XpM6mPS3Jq2vz7iQnl1I+N8m3JHlLrfWGWuuWJG/JkuATAAAAAIfOAf1GUSnlaUmurLV+YOGrByW5fPb5ij5ttenL1n1OKeWCUsoFmzdvPpDkAQAAAHAA9jtQVEo5KcnPJ/nF9U9OUmt9aa31rFrrWaeeeupdsQkAAAAAljiQEUUPT/LQJB8opWxKcnqS95VSHpjkyiQPns17ep+22nQAAAAADhP7HSiqtX6o1vo5tdYzaq1npD1G9uha69VJzk/yrP7fzx6X5KZa61VJ3pzkm0sp9+s/Yv3NfRoAAAAAh4l9BopKKa9J8q4kX1RKuaKU8ry9zP6mJJcl2ZjkZUl+OElqrTck+aUk7+2v/9anAQAAAHCY2LCvGWqtz9zH92fM3tckz19lvlckecV+pg8AAACAg+SA/usZAAAAAEcfgSIAAAAAkggUAQAAANAJFAEAAACQRKAIAAAAgE6gCAAAAIAkAkUAAAAAdAJFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQCdQBAAAAEASgSIAAAAAOoEiAAAAAJIIFAEAAADQCRQBAAAAkESgCAAAAIBOoAgAAACAJAJFAAAAAHQCRQAAAAAkESgCAAAAoBMoAgAAACCJQBEAAAAAnUARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0AkUAQAAAJBEoAgAAACATqAIAAAAgCQCRQAAAAB0AkUAAAAAJBEoAgAAAKDbZ6ColPKKUsq1pZSLZ9P+RynlI6WUD5ZS/rKUcvLsuxeUUjaWUj5aSvmW2fQn9WkbSynnrntOAAAAAFiTOzOi6JVJnrQw7S1JHllr/bIkH0vygiQppTwiyTOSfElf5vdLKceWUo5N8ntJnpzkEUme2ecFAAAA4DCxz0BRrfXtSW5YmPZ3tdZd/eO7k5ze3z8tyZ/UWrfXWj+ZZGOSx/TXxlrrZbXWHUn+pM8LAAAAwGFiPX6j6PuS/E1//6Akl8++u6JPW236HZRSzimlXFBKuWDz5s3rkDwAAAAA7owNa1m4lPJfkuxK8sfrk5yk1vrSJC9NkrPOOquu13q5a51x7huXTt903lMPckoAAACAA3XAgaJSynOSfGuSx9daR0DnyiQPns12ep+WvUwHAAAA4DBwQI+elVKelOTnknxbrXXr7KvzkzyjlHJCKeWhSc5M8p4k701yZinloaWU49N+8Pr8tSUdAAAAgPW0zxFFpZTXJDk7ySmllCuSvDDtv5ydkOQtpZQkeXet9QdrrZeUUl6b5NK0R9KeX2vd3dfzI0nenOTYJK+otV5yF+QHAAAAgAO0z0BRrfWZSya/fC/z/3KSX14y/U1J3rRfqQMAAADgoFmP/3oGAAAAwFFAoAgAAACAJAJFAAAAAHQCRQAAAAAkESgCAAAAoBMoAgAAACCJQBEAAAAAnUARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0AkUAQAAAJBEoAgAAACATqAIAAAAgCQCRQAAAAB0AkUAAAAAJBEoAgAAAKATKAIAAAAgiUARAAAAAJ1AEQAAAABJBIoAAAAA6ASKAAAAAEiSbDjUCWD/nXHuG5dO33TeUw9ySgAAAICjiRFFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQCdQBAAAAEASgSIAAAAAOoEiAAAAAJIIFAEAAADQCRQBAAAAkESgCAAAAIBun4GiUsorSinXllIunk27fynlLaWUj/e/9+vTSynlJaWUjaWUD5ZSHj1b5tl9/o+XUp5912QHAAAAgAN1Z0YUvTLJkxamnZvkrbXWM5O8tX9OkicnObO/zknyB0kLLCV5YZLHJnlMkheO4BIAAAAAh4d9BopqrW9PcsPC5KcleVV//6ok3z6b/uravDvJyaWUz03yLUneUmu9oda6JclbcsfgEwAAAACH0IH+RtFptdar+vurk5zW3z8oyeWz+a7o01abfgellHNKKReUUi7YvHnzASYPAAAAgP215h+zrrXWJHUd0jLW99Ja61m11rNOPfXU9VotAAAAAPtwoIGia/ojZel/r+3Tr0zy4Nl8p/dpq00HAAAA4DBxoIGi85OM/1z27CSvn01/Vv/vZ49LclN/RO3NSb65lHK//iPW39ynAQAAAHCY2LCvGUopr0lydpJTSilXpP33svOSvLaU8rwkn0ryXX32NyV5SpKNSbYmeW6S1FpvKKX8UpL39vn+W6118QeyAQAAADiE9hkoqrU+c5WvHr9k3prk+aus5xVJXrFfqQMAAADgoFnzj1kDAAAAcHQQKAIAAAAgiUARAAAAAJ1AEQAAAABJBIoAAAAA6ASKAAAAAEgiUAQAAABAJ1AEAAAAQBKBIgAAAAA6gSIAAAAAkiQbDnUC7i7OOPeNS6dvOu+pBzklAAAAAMsZUQQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0AkUAQAAAJDEfz3jLrbaf3sDAAAADj9GFAEAAACQRKAIAAAAgE6gCAAAAIAkAkUAAAAAdAJFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQCdQBAAAAEASgSIAAAAAOoEiAAAAAJIIFAEAAADQCRQBAAAAkESgCAAAAIBOoAgAAACAJAJFAAAAAHQbDnUCWN0Z577xUCcBAAAAuBsxoggAAACAJAJFAAAAAHQCRQAAAAAkWWOgqJTyk6WUS0opF5dSXlNKuUcp5aGllH8tpWwspfxpKeX4Pu8J/fPG/v0Z65IDAAAAANbFAQeKSikPSvJjSc6qtT4yybFJnpHk15K8uNb6BUm2JHleX+R5Sbb06S/u8wEAAABwmFjro2cbkpxYStmQ5KQkVyX5piR/3r9/VZJv7++f1j+nf//4UkpZ4/YBAAAAWCcHHCiqtV6Z5H8m+XRagOimJBcmubHWuqvPdkWSB/X3D0pyeV92V5//AYvrLaWcU0q5oJRywebNmw80eQAAAADsp7U8ena/tFFCD03yeUnumeRJa01QrfWltdazaq1nnXrqqWtdHQAAAAB30loePXtCkk/WWjfXWncmeV2Sr01ycn8ULUlOT3Jlf39lkgcnSf/+vkmuX8P2AQAAAFhHawkUfTrJ40opJ/XfGnp8kkuT/GOSp/d5np3k9f39+f1z+vf/UGuta9g+AAAAAOtoLb9R9K9pP0r9viQf6ut6aZL/nOSnSikb036D6OV9kZcneUCf/lNJzl1DugEAAABYZxv2Pcvqaq0vTPLChcmXJXnMknm3JfnOtWwPAAAAgLvOWh49AwAAAOAoIlAEAAAAQBKBIgAAAAA6gSIAAAAAkggUAQAAANAJFAEAAACQRKAIAAAAgE6gCAAAAIAkAkUAAAAAdAJFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQCdQBAAAAECSZMOhTgAsOuPcNy6dvum8px7klAAAAMDdixFFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQCdQBAAAAEASgSIAAAAAOoEiAAAAAJIIFAEAAADQCRQBAAAAkESgCAAAAIBOoAgAAACAJAJFAAAAAHQCRQAAAAAkESgCAAAAoBMoAgAAACCJQBEAAAAA3YZDnQBYqzPOfeOq320676kHMSUAAABwZDOiCAAAAIAkawwUlVJOLqX8eSnlI6WUD5dSvrqUcv9SyltKKR/vf+/X5y2llJeUUjaWUj5YSnn0+mQBAAAAgPWw1hFFv53kb2ut/ybJlyf5cJJzk7y11npmkrf2z0ny5CRn9tc5Sf5gjdsGAAAAYB0dcKColHLfJN+Q5OVJUmvdUWu9McnTkryqz/aqJN/e3z8tyatr8+4kJ5dSPvdAtw8AAADA+lrLiKKHJtmc5H+XUt5fSvmjUso9k5xWa72qz3N1ktP6+wcluXy2/BV92gqllHNKKReUUi7YvHnzGpIHAAAAwP5YS6BoQ5JHJ/mDWutXJLkt02NmSZJaa01S92eltdaX1lrPqrWedeqpp64heQAAAADsj7UEiq5IckWt9V/75z9PCxxdMx4p63+v7d9fmeTBs+VP79MAAAAAOAwccKCo1np1kstLKV/UJz0+yaVJzk/y7D7t2Ule39+fn+RZ/b+fPS7JTbNH1AAAAAA4xDascfkfTfLHpZTjk1yW5LlpwafXllKel+RTSb6rz/umJE9JsjHJ1j4vAAAAAIeJNQWKaq0XJTlryVePXzJvTfL8tWwPAAAAgLvOWn6jCAAAAICjiEARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAEoEiAAAAADqBIgAAAACSCBQBAAAA0AkUAQAAAJBEoAgAAACATqAIAAAAgCQCRQAAAAB0AkUAAAAAJBEoAgAAAKATKAIAAAAgiUARAAAAAJ1AEQAAAABJBIoAAAAA6ASKAAAAAEgiUAQAAABAJ1AEAAAAQBKBIgAAAAA6gSIAAAAAkiQbDnUCADhynXHuG1f9btN5Tz2IKQEAANaDEUUAAAAAJBEoAgAAAKATKAIAAAAgiUARAAAAAJ1AEQAAAABJ/NczOOhW+y9R/kMUAAAAh5oRRQAAAAAkESgCAAAAoBMoAgAAACCJQBEAAAAAnUARAAAAAEkEigAAAADoBIoAAAAASCJQBAAAAEAnUAQAAABAknUIFJVSji2lvL+U8ob++aGllH8tpWwspfxpKeX4Pv2E/nlj//6MtW4bAAAAgPWzHiOKfjzJh2effy3Ji2utX5BkS5Ln9enPS7KlT39xnw8AAACAw8SaAkWllNOTPDXJH/XPJck3JfnzPsurknx7f/+0/jn9+8f3+QEAAAA4DKx1RNFvJfm5JHv65wckubHWuqt/viLJg/r7ByW5PEn69zf1+QEAAAA4DGw40AVLKd+a5Npa64WllLPXK0GllHOSnJMkn//5n79eqwXW2RnnvnHp9E3nPfUgpwQAAID1spYRRV+b5NtKKZuS/EnaI2e/neTkUsoIQJ2e5Mr+/sokD06S/v19k1y/uNJa60trrWfVWs869dRT15A8AAAAAPbHAY8oqrW+IMkLkqSPKPqZWut3l1L+LMnT04JHz07y+r7I+f3zu/r3/1BrrQeccuAut9qoIYCjldGSAMDd3Xr817NF/znJT5VSNqb9BtHL+/SXJ3lAn/5TSc69C7YNAAAAwAE64BFFc7XWtyV5W39/WZLHLJlnW5LvXI/tAQAAALD+7ooRRQAAAAAcgQSKAAAAAEgiUAQAAABAty6/UQTA4Wdv/7XOf3C66/ivWQAAHMmMKAIAAAAgiUARAAAAAJ1HzwDgEPKIIAAAhxOBIvbL3i5oAAAAgCObR88AAAAASGJEEXA34L9QAQAA3DkCRQAAHNXcMACAO0+giKOajuHBp8wBAACOXH6jCAAAAIAkAkUAAAAAdB49O8T8u3kAAADgcGFEEQAAAABJBIoAAAAA6ASKAAAAAEgiUAQAAABA58esAbhLrPZj/ZvOe+pBTgkAAHBnCRTB3YgLdwAAAPbGo2cAAAAAJBEoAgAAAKDz6BnAEh7TAwAA7o6MKAIAAAAgiUARAAAAAJ1AEQAAAABJBIoAAAAA6ASKAAAAAEgiUAQAAABAt+FQJ4D14995AwAAAGthRBEAAAAASQSKAAAAAOgEigAAAABIIlAEAAAAQOfHrAHgCOOfFwAAcFcxoggAAACAJAJFAAAAAHQCRQAAAAAk8RtFwFFktd9tAQAA4M4xoggAAACAJGsIFJVSHlxK+cdSyqWllEtKKT/ep9+/lPKWUsrH+9/79emllPKSUsrGUsoHSymPXq9MAAAAALB2axlRtCvJT9daH5HkcUmeX0p5RJJzk7y11npmkrf2z0ny5CRn9tc5Sf5gDdsGAAAAYJ0dcKCo1npVrfV9/f0tST6c5EFJnpbkVX22VyX59v7+aUleXZt3Jzm5lPK5B7p9AAAAANbXuvxGUSnljCRfkeRfk5xWa72qf3V1ktP6+wcluXy22BV92uK6zimlXFBKuWDz5s3rkTwAAAAA7oQ1B4pKKfdK8hdJfqLWevP8u1prTVL3Z3211pfWWs+qtZ516qmnrjV5AAAAANxJawoUlVKOSwsS/XGt9XV98jXjkbL+99o+/cokD54tfnqfBgAAAMBhYC3/9awkeXmSD9daf3P21flJnt3fPzvJ62fTn9X/+9njktw0e0QNAAAAgENswxqW/dok35vkQ6WUi/q0n09yXpLXllKel+RTSb6rf/emJE9JsjHJ1iTPXcO2AQAAAFhnBxwoqrW+I0lZ5evHL5m/Jnn+gW4PAAAAgLvWuvzXMwAAAACOfAJFAAAAACQRKAIAAACgEygCAAAAIIlAEQAAAACdQBEAAAAASQSKAAAAAOg2HOoEcGidce4bl07fdN5TD3JKAAAAgEPNiCIAAAAAkggUAQAAANAJFAEAAACQRKAIAAAAgM6PWcPMaj/uvRo/+g0AAMDRRKDobmB/gx8cOfzXOgAAANaTQBEARyzBUgAAWF9+owgAAACAJEYUAewXI1gAAICjmRFFAAAAACQRKAIAAACg8+gZcLf9z3iHOt8eYwMAAA43RhQBAAAAkESgCAAAAIDOo2cAHHU81gcAAAdGoAgOc4f6d3TgYBHcAQCAQ0+gCACAI4rAMgDcdQSKAA4zLoAAAIBDRaAI4AghgAQAANzVBIoAAA4iQV8A4HAmUAQcFC6Mjmx+VB042LQ7AHBoCBTBYWI9O8Q61wAAAByIYw51AgAAAAA4PBhRxFJGpKydMiRRD5ioCwAAHAmMKAIAAAAgiRFFAEc8I1W4u/Nj+QAA60egCIDPOhhBp/3dhkAYAAAcPAJFAHAADscAlpE1AACslUARwN3Q4RjkgOFICng5lgCAo41AEUeMw7Ezfjim6UiztzI8HC8KAbh7O5ICmcD6cexzdyJQBABwGDvSLk6OtPQCACsJFAGHLRcbwFoYsQgAsP8EigDgMHUkPd56IGkVrCE5suo5ANwdHPRAUSnlSUl+O8mxSf6o1nrewU4D6JQCc0f76LUDyd/BaCePpLb4SCuPg1Gnj6T9txqjzu7oaG8PAdi3gxooKqUcm+T3kjwxyRVJ3ltKOb/WeunBTAdwZDsaLk44Mhztde1ozx93P0dSnV7PIJXgzh3tb124O5cVwKKDPaLoMUk21lovS5JSyp8keVoSgSIAYK+OpCDA4epQXjwfaftvf9N7OObvcExTcngGttYzTQej3NcrmLie29jfba/nqNbV1nUgAdnD9bg5mh2ObcLdXam1HryNlfL0JE+qtX5///y9SR5ba/2R2TznJDmnf/yiJB89aAm8a52S5Lr9mH4gyxyO25C/I3sb8ndkb+Noz9/B2Ib8HdnbkL8jexvyZxuH87YPxjbk78jehvwd2ds4kG0faR5Saz116Te11oP2SvL0tN8lGp+/N8nvHsw0HKpXkgv2Z/qBLHM4bkP+juxtyN+RvY2jPX/K8Mjetvwd2duWvyN720fLNuTvyN6G/B3Z25C/5d8dLa9jcnBdmeTBs8+n92kAAAAAHGIHO1D03iRnllIeWko5Pskzkpx/kNMAAAAAwBIbDubGaq27Sik/kuTNSY5N8opa6yUHMw2H0Ev3c/qBLHM4bkP+juxtyN+RvY2jPX8HYxvyd2RvQ/6O7G3In20czts+GNuQvyN7G/J3ZG/jQLZ91DioP2YNAAAAwOHrYD96BgAAAMBhSqAIAAAAgOZQ/9u1w+2V5NuT1CT/Zi/z7E5yUZKLk/xZkpPuxHrHMh9NsjHJ1yR5VJ9+VZJtSbYn2ZzksQvLPjDJnyT5VJLbk+xK8oX9u/cl+fUk/yfJniRX9+28Psl7kpy1JB0XJ7m5b/N9Sd6V5GeSvGRh3uck+d1Z2mvf/qX987mzeX8wybP2kv8X9fw9MMlf93Vt7en4cE/7RUkuSfKBJD+d5OuTbNvLOk/r+dzR13dbkk/2PP1tklcn+eDs+13p/8owyW/0aX818pHkb5Jcm+SGvp7HJnlbkt/rZfWsJGcn+ZpZGl6Z5OlL0lZ7fj+Q9iPuX9nTcU0vz5Nn827pdeLGXgaPzUI9THJG32+L01/Z98lpSf5fL8dtvUzfsEr9flmfZ2ffB+9Mck6SN/T9+GNJ/ny2zB/1NNf+90M9Pf/S83Rbz8O2vv13JfmOvuzbkvx+36+b+jre2Zf5UM/TF2aq459IcmGSjyd5dp9/S5Kv7cv/YpIXzevnrP5dklb/L+/rfewsD/8yq4c39PLZ0svuQ307N/d01bT699y0+n92kpv6vDcn+Z+zsn95X9cf92mPSfL2XrbjeLmk5+uavv2f6fP+U5L/1cv0nT3P70vy2iSnzerR/53lY0Of9ukkf9nXf3Uv+z/PrH4k+Ykk/zfJ1bPy+scsOU57Xp6e5KwkO/q0B6TVx4v6OsdxtGf2+aosaQPT6+tq25m1a7W/ru/5f02SV6UdOx/M1C5cnNZuPDPT8Xp2eh1P8m1Z2R7duuyYnL1/Si+3P0+ye6HNuy3tv3GOdF2c1vY+dpbujb3sL0zy7iT/336cW65K8s9p9fmUWb38mSS3Jvm+tDp1Y5LLejqf1cvi4z09O/r3n+7puL2v+4b+d2evE6N+/NnsOPlw388jPaMt/mgv6/dk4dyRqf15U5IfTjsu9vRyuihT+/Ab/f2O/nd3X/futOPyG/r63trzurF/d0OSj6QfW7N25+1Jrkg7LkadG+38yOtoU0bb8aa0NuW9vXw+0Ze/MMl/6uveM0vnVb2cP5jp3PmI2fF3Vdp5+fY+/660du3snofdfX23px+rSX6+T78t7Zyyvefjokz1a/y9qOdn3q5/R9/Gtl5+F6e3qQvl84T+3Tivb+npu72X3RcuLLMxyf+cldsP9+mP7Z9vSjtnvS+tj1KT3DIr291Jfif9eMusDV7Yzv/qZfDAJP/Q8z72zSVpdWGU9xvS2p5XZmXb8OZM58TRT7h6VmYXp7WVn+j5ui3TcXBlkvPSjqkNff+9Je14/51Z/m9PO6ZuSav/n8jy8/mtmY6BTUl+Kq09v2j2uny27dsz9ZvOSG8Le77+tad1a1q92NHXf2uSN6a1BR9L8hc9PeP89HXp5+WsPPfN1197Oq5I8o4kv5B2zP9Wkkek1amzkvy3JE/YSz/1g3095y58f3ra8VF7en877Vz5gkxt9ag/W/fVJs7K9ta0/vBTZum4qpfjOHZGH+/z+t9npLXPn0yrUx/uZTnautcm+f5VtvnutDrzyrT2bE+Sb+ll85a+jd9Mq7uX9PTcnuQzvWw+kqkOfTitT1x7/m9Pa3velJV9pjH/9j7PDUmetiRto6+ybbaPn5J2bD5+dm7e2KeNY2K0j5em9Qdf07e9q3/38ST3mm3nRT0tv5/kTzO1Y1f391/T5/uJJCel1aO3ZapHi32Tf5nlcZyL/jTt+Ls1ycf6fO9K6zeNujzOG+PYfVWmPt6eJNel1cXPJDljH3Vp9IMvy3Q99aOz8qxJfmM2/8+k9cOe0Mtu1OFdfdn/uFhX+9+3JfmBtLZrd6bz9J/N5nllZm1JT9u7+j67sL//jsz6AX2+7Zn6sqN9ujRTv2tnWnu1OVNfaOyjbUkeP0vDvDwu7H9/e0m/ZJzvbu37ed7vem/f7g+ltfmnph2PO3ra9iR5ftq59qq0Y/OytOuvF2b5dcgZSf5jllxv9zT8l14G4xzx8szqW9r13QWZ+u3bezq+ZmE7Z/fp47x2U6b+7X9IctUqafvThe0/dnG+fdTDxX26tL09Ul5GFN3RM9NOsM9c/KKUMn78+/Za66NqrY9MO1h+8E6s9/a0k9CvplXAX007Mda0SnXftIPmY2mN4thmSbsgfFuSf5vWcdiR1gAk7b/GnZTkC9IOmN9PO+H9UFpHZFk6bknrZF6XdiH5jCTba60/tlraa62PSmsA7l1rfUTP/3mlOabW+oe11lffiXL4y7TGJbXWk9KCQeekdSoeVWv9kiRPTPLktAv1pXq5/FXaBc3HetoekXZyf0GSL03y/yW5V5L7pDU+16SVd9I6wTuSfHmSPyqlfHWSL07r4J6fdmCP/fDcJLt6/s7uy+7LuPh6XNo+eVnfXtIaqht72X1NkhPTLqBOTjthXZ5W/96ZO9bDz9bPWX1ML4tr+vsvSfKktI72Z/X5/1OS70k7QR6f5CFpjflpab9Z9oe11pfUWp/+2YzU+v1p9ea2tJPik2utm5L8UqYLwhek1bk9afXp9L74fdI6uI9O6yDfmrav75nk3yW5R9/2XyZ5W6314bXWr0y7cBgn+/sm+ZzlxfxZH+jbenHaMfLjSS4fZVRr/Zr+vvT5x8no19M6jVvTjsMr0zoJT07ytNn635/WMbslyb8rpXxtn/6kJE+stX53KeW0tI7Cf850Ifi9Sb6p5+OkhTT/Y1on95i0TtOZtdZHp9WXU/s8tyV5ZCnlnv3zE9PK+INpJ71P1lofmNZZf0KSH83Ufo3/KjnWlSSX7O04rbVekF5Pa63X92PyUWmdk59Pclut9ZiertPT2rIvyqwNXKiXi0qfZ7RroxP7mSTfnda5/Ly0Ds+nM7ULj+zfPazWet6KFZayodZ6/uL01dJTSnlikpekdU5vW7LIJWn1aFeS49LqwtuSPGGW7o8k+YVeV9+f5Bv2kufhuT1f/5q2/5YmN61ePq63B49O29//1L9/Wdqxe0Nau/dTtdYTk/xkWjDrV/v8H047bv59Wl2/JUlqrX+YqZ0Ybcm42PnutID2V2f5uSO11qfMvtuV5MW9fowLun/f35+Tdlz9c1pwNz1djymlPDotkPPqJN+f5G9qrfdP8hVJvrWU8rW9nM9JO+ed0td1caYLld9Mu7Afnf/jZ23HC9LalFt6mr6wH1dPSnL/npatPZ3Xp503r6i1flnaMfRDtdZLZ9m+V1qnPr18L+5lmrQLwLeldeTfn+Q7ev7+Ja1OPzvtGC9JXtjL6kvTghi/MSu/92Rq10ta/TwxrWN8UpKnZmpTU0o5vrfLG/ukcV5/QdoF4mfS2oLRT1g06v34r7P3T9s//1xr/fK+nl/tZXtCWiDpq9La+nvu7Xjr3pV2HP9lWln/Vt83r+nTf3ZW3iuOwdkx9pe11pN7+Yx+wh+mBT2+ouf3H5J8Ua31C9L2Qenr25xWP5PWZl6ZVhd+I62OvrN//+C0OnZZz+eOnoZ99Y0/keS9o33safzvvQw/knZhf13axdnI13/p2zmzl8k3pt1YuDatXLf1PCTt3PyWWuvD086Te9LOz589Lyf5ylLKRWkBiS/p75Pkf9RaT09rD27rx/zJacdNkqTW+ou11r9fkq/be5ouSvIt833c98vr0gJFO3san5Xkl9PayV29LEb9OaGU8txSyuZSykWllEtLKT+wlzL9jbSLv5GOW5N8V631hLR6vr2XwWfS9v2vpF2sb0hrE5+cVua39HU8Jq1flNFPXbLNk9La2+211jf3899xaXX0PkkeltYGj5tEr+j19ssyXYC+Nm1/7+n14Jok9047797Ut/Md/e81aTd1vzPJxlrr6xcTVGtd0b8spTw+rT34ylrrW/s816e1nf+cdky8OK3eb8x0A/S6tLp1WVp9e2WmPuh8ez+c9oO8Je2c+8d9vl/ts/xEL6eX1VrPXmgbH1lKObHXjVH/x02De6XVkSfOyiFp562/mdXlcd7Y0Of7op7vY3u6T+zT79P7naNcFs/r45rg7Wnnl6v6toddY1ullFPGYkn+sR8LO9L7G2mBkIvT6sa+3F5rfViSz+3rOG5xhlnaPpbk//S2cN5PHvN9dS+HH0o7bzw8rX0agdhxc+HNSX51dnz+RBb6l/PyqLU+rG/zGzOdM0YZfkdWtg1/mJX9rlPS2pIH9u09Pq1e/Xyt9cy0Y+MlaXXnR5P8SFpbdtZeyuyMtEDRsuvtY5J8a5JHz84Rv5CpL3xin+8+vUz2pAWmd2Wqs8PZafXxHb1dui7Jhp7v6zNrn2eekuSbF7Z/+ZL57rS9tLdHhrVEmY62V1rDdmVaI/PRPu3stMb4/LSD/Ji0k+RH0u48XJwW3bx/2oXfuDvyzrSG40VpkeE9aRVzZ1qFvymt0o47Dhek3Q3ckeTvMt2NHdH56/t6dsym1dny44JrV1//tv4adwfGHc89PQ3j/Z5Md0tHtHrHbJmdme4Kz9Mylh13ZXfOvn9XWhR6S6YRCCMa/v5Md4d2Zmq862zeHZkuAGrahds4KY875Hv6cttn696T5A/SOjPz8rmtb2fPbLnFMpyvZ7x2LXxe/H7PbL4bexn9Tdrd9nm+d/e8fmK2z98xK+MRLLxxVv6L+3e+zesW1l9n25lvczGPi2nf3cvyqiXfb800kmTx9dG0E/Di+j7Z329Ju/C5YpaeTy5Zz2pp3DNbz7Lvdi1Zdn63ZbV9tlhP5+tbbT07047rrQvLbZvNM0ZEjOVvWUjf/PgZ9fA3e/neMlvfvI7O9+1qaV12/C/meVkZ71oy3860E/2mTPt/98L8OxeW253V0zXamwtzxzq5c2Hb47sxImAx37dmZT0f7dPNS8rmA7MyrWkdmq2ztF8/W9c8zaPsd2dlWzA/RhfzPM/3joXp8/RvycrRL/My3NXL/DOzz6Ms9vTpm3PHenvTKmldtr+X1aPtq3w39v24aJ3XlbHcpr5PRr2dr2OxHmy7k2naNZs2L8sdmUYRjXlvyHQHfbxuT2s/RzmMcrltNn2s84pZWS2W6zj3XJs7tsO7+rZ3Lflutddi/Rnrmbcvi98vpmn+ebEuLi67t2NyvObnv1tzx3Z2lPl8nVvT+j+1l+n82NvXeXLZa09f57K2buThqrQgyIcy9UPm6192rM3zuNjGzOvyxqxM//bZtuf7Z56mC/eyrWX7YmzrloUy2pF2/L4u7YLv9rQ6N++n1LT2eEvuePzcnJV9gMV6cmGmPtLYX8v2/0jbqIOf7u8vnH2/Le14397TXGd/r8002mCk8S1LynqMwhvzbJ6ld57+d2RlW31T3/5zF9K/OHpyz0I5jbws1pM9C9vcvfB5vo/GOXy+P+b79KIl+3qetsVjYXEd/zt776d9Ysm0m1dZ9/z9vO+xa5an29JGScyXuaV/vnxJ+mpW9sHn+2tZ/3Rx3sVyH3m9Ysk6V2szlk27ccn0XWk3vPd2TN6alWmap33XQvo/upe8zD+P0euLZbFYHqPMrsnK67Fds7+jP7N9YV2Lbe2+0lXTAoPjumxeRpsz9fWvXCifcW6fnxPn6x7r2pk7XnPNy/zvF75fPDcs64Nv69O3Lsw/8nD7bPs3zcptbONTS7axrP58eEnZrVaW4xj/SFo7M+rJrrQA9M+mjf68Oa0dvCrtun1Tn7ajL/fp/nlrWl05J62tGv2X2/s23p12I+tdadfI/5J2A+SQx0WqEUV38LQkf1tr/ViS60spX9mnPzrJj9davzAt8l3SIrDPSQsqfTptdMXDkzw0bVj2g9LutCTJGA1weVrjfGLaKIOf6dOPSbtDce+0g+xnMx1MV6cFke6fVhE/kVZpfzvTHbN3zvLwybQT/fFpFxk/nWkUxb/tf0ta5HVHf//e2Tre29cxTtj/2NN3j9k27tOXu6xv47i0A+UzfZ1flja8fTQ+56cdLEm7azciqzemHSTjcZonz9L6Df1v7XkdDejJme4KvyFT9H5s6wf7esYJ++ZMkfar+/rH9mraAZm0Mh3bHnddds6+G393pjUAO3u6xgnwi/u0b0x7hGo0kqPx35CVdw8ekdbZu6qv48GZGtvb+ncfydSIJtMFykl9m7+Z6U7Nrkx3rs9NG7WQtI7oWP73Mo0G2JZWr05Nq5Oj8zeGtZ6Qdqd8nDQz+3tq2hD+sZ6tfbv37en6SFqdOSWtzG9Mu4OwM60hHebR/0+klWsyNZ4n9897ZvNtyXTXOH2dN2c6Xsa+Hftsx2z5r89UXpelnWDGiWHke8z71j792LQ76Sf07+Ynm3HxckzPyyiHv840auPatKHt4y7Ir/Qy+bZZ+pIpgJG0ujDq6p5Mj7fc3NM88n1hpkccRp1MX25cLI86/d5MZT+ClOn5eXnPw7mZ7pw8LG0IeDK1U9tn69+TNipx+KM+7aq0oc67epk9Z7bMA9PqwjFpF0njYid92jGZTsp7Zt+9Y/b+1rQ6N9qkq9Paxdv63y/paRhB6FPTjscb+/Inp49o7Ov8m1nevquvf8OsfI7J1JEb7e1YtmZqNz+TVjffnbYvr+vTX5Z2XNwvU0fk1kxleWxaHRij/0qmNmt7Wt05PlMH6nV9+jszdYo2pQVmt2blndthd09fMtWxcTf247P5Rv7ukRYkOjPtTt2LMtWt63p6xvlgT6Y6Njp94/3Iz5i2qf+9crbMKOebZmm7Nm1/Xp9WPselle3mtHPjy9JGyswDGsem1ZM3pnW2js/UNr+/v7+kl8MJmerbsbN0bO7pOiFtKP1oj0Zejs3UJh2XVvfmRp24PFNQpcy+39m38aFMwcxb00ZSjCH8OzLVuVGeo3Oc/vfSPu2Wvv55OsbFc9JGN75oNv11/f2GTPvznukjT/rnWzKV+YdmZXOP2Tzz/Z+ehmv7Onf2tI1A55i2O61NfMfCMrf19+/IdEzc3pe5V9pI6ZHmN2XaJ+n5vCZTcG9MS8/D/Ly9K61cx3n5of270a84vn++Jq0/d0zaaIJ3ZWpHz8zKR7Cv7++P6+m6sa9j3pZ/MlPf4so+7ca0eviQtHZ2W9/+SZkuDJNWxjdn+i3Rkcfj09qTpJ1rRttxe//7FWkjcMfxcWJWBls3pB3Hu9LK+Kaex1N6uX1FpkDee/o812Q6hz2j/70hySP7ukc/6rSe19GuvayXT8nUDl89y+f83H5Gz+vou9wn7Vj8kUz1f0+mundcn7ekHZdbZvM8MNOxd33aOeGTPV239fyO+jDmuz3T+eCGtPaqZDrf3Z5pVPrnzrY1LiyTqf29PdPosPn04Tl9vT+bdoyO8/tV/fvPX1j2+kz92BHcuzHT43DzvtPI141p/aqk7fPX9fmuSOv7ndTT8HmZRmGNYFDS2sCk1YMPpLUnl/d1Xd+/G8fT2E5m00fZbZ29HyPTa6Yb70kbJTjsTuuvbM9KNe14rGnn2dGu/07a6JSk9VeT6Ri6Oa2NnV8njAD1G9L25660UVSjvZiPwP5o2rHyl2l9paSN+C5px8toN0ZbfkumvtRtfdqOtLbu/j0dH09r725K64cem7YPF89HSdtH52flcTKMa4PRDxj9tQf1de1OqwPv7nkc/ZOkHUOjL/Khns9/ztSGJK3fMvqbP5Spb/S+tLK/IVO9Sf/u63qZvKtv79g+z6hLx6S1FeOG4OhPlLQnHcaxuK3Pc1xfx9/16SOo9+nZvA+cpeGKTDc+xrXU8LDZ+7emlX3S2qg/m303lj8lbZ/VJM/ryxyTti8vTwsYvT+t7O7by+dv08r8uP79l/Xt3pw2gODHeprGSLBP99fb035e4+trrV+RNgr7V3K4ONSRqsPpldZwPLG//7G0YMfZaUMTxzy/lSnaeFFaA/mMtEbkltn0HWkV60XpgZfZem9J67Q+J9PdrbPTHi+oaQfFPMI5Ku4bsvxO0qWZ7iRcnOl3jC5PCw7NI6SjYd+SaWj+zkyR/o2542iIEfmcR2x3pz1WM0ZCfCbTiJg9mRrgkf7Rgb0ibQhsTet4HZcp+j6PNF87S/efZ2oQx7Pe48JwnAh29LLZk+TnZsvO7yyP3wTYVzR58c7l4nyLd9FvSnvE7A2ZLpwWl6tpHaTrZp+vzzRKbFumO22r3WUadyZHuV47S8dnZvto3JkcJ69xl+Oahf056tXi3aARXLk6d0zLKNNl6RsXBtfNtr9n9n7xTtRrZ/N8ICvrweIInvHaOltmb/turOfWTEGwH850gb2Y7sX3n1plneO1K+2YH/vjCX1bu9JOuDcszDvW/aK0NuPqtMePbpltY6zrlzONgpjvm8UREKuNGKhLlp3fJb8m00X07rRjfk9ax3is82Oz+cdds9ct7IN5vj482w+Ld5lGJ/teWXmhNU/rCA59PFMbMh9ZMK9Lt80+z0cajPQs1p2taSfjmnaMjt8o2bawrsWRjYvvF6ftzPTbOf87rZ7dsLDtkf+Rn5syBftHum/IdOzuTjsPbMl0F3BeFqOcrlvYzmJaRwB15Gmet22zeed52prpTtfY/1uyclTQ5rSLjHGX88pMF8w7FtY30rGsDZmXz7Jja1umUQK7ZuuZjxYb39VMF53z9Y+yXBzVtDjCYlm6fmlhW+N13cK+Wq2tXrbuUX8X69GydYxj77KsHBE1tjnfd/MRf9fP0veSTOfRxWNt3na8d5UyWdyXY13juBkjk2/MVKdGG/axTPV0pOu6TPVrMQ0/kekifM9sO1elnfP39HTO8z2/ENuxsL7FkR3zfXBVVm875+euxXnm557tacftyPdnsrJt3ls7Mm42vTrtAuFTmfpf85Gqt6WdI+Z1YpTJOJden9XPx2OfzgPvNVNQcrzGBdV8JPmHMv0m5tj22Ob39nluSbvo25X+ezy9jzvP6/wcMUYYb8vy8t+Udl786/75Uz1tl83KZAQRxjG/7BhdLPfdafVknMfm+2mU9yiHq/v00VdbHOE6r5uLx+P4PPL9sSXTx8X5roXpi6/5uXtTz/Mo/5uzctTp4rE93l+cle3irbljuYxjZVm/eOfC+1tm08Z8o86sVgcX98kHZp/nx+h1C/Ottr5NS/I8P+fO26ixnt2ZRsmNdmdxHfP6eOvC+3k7s1inF0cfjfV+YmH6CKSPa7PFtmJrpsehR99i9N2vWZh37Lf5KMhb0h6XGmW57Fw8P9dc3pd/XVo9Hcf6vP58ePb505kCbFdmZd0erwvSHnXblZV9sN2ZjqvRLo31zgNdH5tN35r2OOT8c830MxFbZvm/OdP5aORxWd7fN1vfxrRBEGPd8+P0xb0s/iJTPRrXl7vSHh3/sUztyrgu+9O0m+uf7su9rG9z9Lc3p/X/tvTp4xru42k/k/KatIDkxWnt70cOdUzEiKIFpZT7p43y+aNSyqa0SP93ZeXohWFHnZ5L/0Cmux0fn02/JtNzyXtmy44KeUraCKIk2VlrfVvaxUbSfg9gd6Yf0xp3+a9J+xG7pI2cGXcS62z9F6cdTMf0tH/3bJ7xzOiOtCHCN6advG/PdKf053t+rk/r/PzfWbrH6JFx0I7nyMdogd9Lq/gl0yMnt6VFWccoopHn4bvTItF70kYujLzMH4cad+NuS7vQS9oJ4yGz+XekNVIlbXRP0hqSm/u0G9MOwuMyNVbJdJCPAM+e3PF51NHw3NLXc2zaCJKP92VPTDvQP6/Pd0Jfbmvac9u7ZmU17Ezbvy/PFGQbJ/5jsvJkmb78Pfu2j810p37cGb460yiB8zLVpQsy3T3/rUx3DD6Y9ntFI2p/S1oDdmOmHy39nLQG68ZZOWxL+42CYezjKzLVhb/q2xuPCf5xL4Oxn9PzdcYsfw/p6diRtq/HSIdxcXVt//w7s/IbZXRhpgvXv5tNH+3buDP19ZnuAF2XqRM1Xsl01/bX0vbfGHU30jwvi/n0caFSMt29qmnH7H/tn8vCsvfMVFeu7du+teft3lnZERp3Cv9uto6RvlFOi+ajGT6QNgItaXVu1Pnbk7yiz/vzme4QvS5T8HncDXp0/3t8T+NrZ9v5rf73Q2knwdHRHe3AlWl38UcQ9Y2Z9m3SjoGSdvdldExHXR13tcYdtLFfR4fr//X1/3Gmk++2vtxor8Yx/VdpIw7Het83K6Nzezp2Z6X3Z2V5j47Hnkx3AJO2zzb192O9P9LTWHq6752p3Rqdwo2ZAkqjA/my/v3FfdmLZnn++UyjE2takHrcof/rPv3GWZqTlRceo46PkWfDJT2vmX1/77Tfx/nEbNq8E7ZrVgaL/YndmdqepHWqR/Bg+PVMHbEbZ2n9+9lyo74k00ihzNKRns6S1t69LtNIlfv3v7vSRr2NTvxY7+5MFztjJG/Sbv6MfI3HWJKVow7nHevtmUYRLl44zduQ0TZlNs8YQTQuQMa658f0mD4unj+Y6Tw80rwhLfBwcf/8LWmjMpLWQb22p+32hfQ8KtMojTfO0jw/X83ryba0kSZj+V2ZRoGM0SRj/WO9J6WdX86drefTmdqbe6T1icbF4O5MN99GH+CFmR6TGcb5fIxcHUpWnmtGWzFGAszb4hF8Geubj0Z6fc9r7d+NC5EtmY7pZPpB+WQaMTj24divv9C/vyatv/WwTKO1xiiGse6xnfkoppH+UWeSts+vmC07jLv4I8A6bjLM+zlj+kfSLprGObOkjZT/nF4W29L6g/+9r/v7+jzvSxtFf2ymUd7z7df03wjq7zdnGmU9gkWjPc1svrFv7tk/f87s+52Z9tX1mX7TaFyIjeNrHB/JNDr+gZkChaP93TLL8zVpP10wT0NmaRzn5p2ZzttjP4z5/ynT6MRjZtMX29xxbH0gU/Bid/+crDyv3Ku/Rv/uxKxs20ffJ5ku4Mdyo++6Na08xwXvH87StiVTv2hTptFCx2bqt96Wtr/Hd5/sfz/R0z76PMO8TzV/P27SzIMWyXT9kZ6ueTs/8rgz02+pvS5TcOk1s3k/3Oe7rOf18kzt/zDag92ZRsaP/ZBMI/92Z+qzjuuapPUz0rcz8j1GMb+6fz49bZ+/KtM+2JDWl9ueFmCd93E+3Jf9l0znjZGGB2RlWY4bHyNINQ9yZLb8CCb+SX//X9NGrybTqLPRlpReZvObIF+bqX6P82hJa68e0ucZ7f5Y5ymZRkaN89xtab/9OoxAylgmmX4XbAQzj8/0G0SbM40QK0n+R9r5fvR9Rzsx1jXOKduz8kbsqLPp6//8/v6XMx13e9Law6T1Bd+S9pti/5z2u7XHZPonD9em7fcXp9WzT6dd0zwirX79x7Q6+vG+7T/N9Fuqz0k7Jv+q53132pML/1jb70L9u6wctXtICRRNnp72I2MPqbWeUWt9cNrO/fqF+d6Z9mNYx/Qfrz27T39rkoeUUr66lHJ2WgV58JLt3JrpYn8EesYw4vGo281pFe2L0/570Sl9+rdl6hQ+LNMjbWNU0NifY1jshqw8iH64T79H/3xC2kl4Q9rJZ0/akLftaUPpjkt7lCOZGpbjMp0kk3biOCbTUNiRhg/19yf29T91tp4xBPD5PY/jxDwet0naD9qNvL65p/nGtNFCO3uZ7OnrHye5UY4nZfkJ6OszNXajgR93meYXJSdmZedlXNgf29NxbNpv9Ly9562k/YL+l2bq+KVv4y/STsQnZmW5bU9rbH8ordHbmqmDPYIv887ucX2e69IasO1pDeVoFE/MdBJ/zCzf44SUtIvAka+RxlFvjkvb5/MOUOnLj3o2yu5vZ9u6La38Pzet4Twm7aSyK1Nj/8WZOmfzDtOXZer4jjo5vntwpqDZMZkueH5gNs+84z/q70mZLrpGuY0h21+UqTzvP9vmKPc6y/85aXfxbspUJ6/JFDQYJ5qRvmv7tGPSOmjb+nLb0+rs8LBZ+k6bpeeEtLp070z7t/RpV/c0zjsQY2hxmX0ewbVxYhwdy6SdxEZbNgLGx6ZdeD5xNt/G/vdefZljZ+s5vq97lNe4OBgXHEkLBm1JK9uSFowcj+yMAOjolMyHWp+WqS6ODsB41OHzMl283iPTsTuOkUf2aY/MyguLW9L2/cVpd3rS5xmdwwdm5fD203s+5he6STtOb0s7DkaZ114eN/V5ntL/3qOn85H98/dlKr9xV/7GTIHCY9ICcCPvJdMjF7syXWiNGwTHpXUQH9Q/b0+7aTDKZdTfEZBfPJ5L2nE+6tF86PgD0i4Q92QK+m5P+w9PD51t/5S0+jECg/P1jeNuZ1o5ztvVz8nKwFFNG6o+9vmo4yemnfeG8djuuLDYNVv+itn7PWlt8Nf1fNe0dmlctH1OT/PD+zKjfd3Qv//KrHy8Z5xXRoc1aeeYcSGxPSvbjtFG7erpGnVofhyOeZOVjxW9JysDX/fq3z0g06NDY/vHpbU9Yx+Nxy3S8/uo/v4hmYJGo70/Nit/9PSYrHy8+NRMj4jMA97zYNeOtGNnZ8/bfXpZbJ2t5z6Z2udkCuh8xWzbN2Qq42/PVEdH0O/0nt5Rh5+ZlcHZ22efT8t0jIw0z0fOjX1c0x4v2rawjtFnGhcWYxtfm1anymz5YzPV5eNm6xzn2RNnf+ft8CjPe/ftPCRtP5+S6Tf8tmd6TO6emY6jcfF8fKabW+nfjUcv5heT837WOK5u6ev53Ky8CXdrT9Noy25KC8D8bKbzeDL1T0e7f0Ommy2PymRc6M3b0BHQHkGlcb44bjbf1l4ep822M8p45O2YTD9L8MC0fZNMN3TH/O+ZpfujaftijAC+arbMOGaTth8enukYvSnT/hvlP/rv40bj9qy8AD05K9vxke55cPyeWbn/xnF0bKbzxlDTLlwflOnYmpdFydQWJ+1Cdd6nuE9Wns9OSDv+v2c27caFtM2DfmNfjj7xffv0kf5l6xhpOybTSP6R1tMynUNPnC0/biIM875NZnmc9wlHm/SVmdrR+/b316WV6UjvOJ+M4/e4tL7Pt/bp80euRmBwbGdDpicwkulcOK/jJ/T34ybUaCv+Q6YbAUmrH9vSrqt2ZGrbTk8bIPDQTP2i0ebPr0/GdduutP7ZjkyPEs/7caPdOzHtnH5sWl04s38/bhL+29n7Uf6jD/Sdmc5JN2a6Xr0h05Mg8wDhl6a1aelpGsfF/HosfT3j/Lxllp7r+/pG/u/b/x4/K4uHpvXLb5xNuyVT+Scr28vrZ9MXb5CM65pHpdWvseyj+vd/nXa+OjOt7fiLXjbfkHa9f3LaefjtaYGkH0i72fYtfd1XpT06fVtaH/bktGuzZHpU9Jtm5XJcpr7Fc3I4OdRDmg6XV9odlSctTPuxLPyb8dzxx6z/Pu0AvX+mH7O+Le2C6z9letRkd9pd4UvTKuFlaRcRdfYad33emSlyPI8YjzuvdeE1v7O5K+3kdXlPyydn84271eMEX2fbGUMVdy5sY3T+5ndIx7b+MtPjbJ9J65CPO0Wbs3I46Zb+911pB9OYPr87vVgW43VML9sR7R7DkT+Z5UP5x2MTi8M753f3di98d8OSeedlOqbNtzW/07e5l9Xts+HX407CjkxDd0eZfE+mO4djG2M7W5ekb6zvwrRnVxeHHS+mbdlr7N9lZTKvY2P723LH8q1pJ6jfXLL+eX0dQZX59/M7iIv7f1l+lg3ln5fr4rT5fpvfZRnfXZf2LPLeymi8bkurcyPAtXO2nvkogvH5HzM9fjDufs3Xt3lJ3sYItZpppMKy+jfPy84l8y17vzMrH1mZ1+P5eudtyq2Z7mjNhy5vWbL+xfWutj9umuX32zI9Ara4D2/NHct3lOGHsrxsrp/ladS/XVk5dHxPWsfkU/3zJzKNmhj5nG9zMT+bc8fh6ltyxzKY1/3tuWN57FrY1ljf2J8jH2O/jbzfkjZCdHFfXpU7pmG1fXRN7vg43q5Vlh/HyYWZfgNiPv8IYs/r5Hybn1pY17wd31t6t2bl8PQrZ+tebA8X6++8rszrx+2Z/tvV/LtNe8n71tnyezu2li277Nw81jn/fPuSde7tWL52lof59L3tw8WyWm3aluz9n2TM51vsAyzWjbow/22ZHrVYPLbH+3HczNubcQNkzHfjkv1d0wLwi49lLEvffNkxmmW1+rg9rR1fzNOerDwGF/fD3h5bHZ9Hu3RzVqazZnr0etfCssvSeXOmxz3n+ZynYb6e+aiiefr2ZPo9qesz/f7efNntmUYuf2ZhO7em/dbKRbP5L1pI8zivjTLatfBazNtq9Xu+zmXluPgaI8jmeRh1fH78jp9qGMvM+yNbsvqxvtqxO0/zqPfL2r9lbcz8NfK4M9Po5/HdTftIy61ZXse3rJKPd2T1R/3ndXhZuzs+z8/ri8vO07t1YdnFOrls38/XtWz6x2fruWiV9X5yybT539Xa3nm7tdq5db7MuMm/c2EdYyTcYju7K6vnd1naFtM377/P+3fz/vOy/FyeNtLo6kz1dNSZxXPpeAz8stn3O7P8EdKtC8suO342Lny+ccl2a1b2lz7R3189y9/I9yjzeR6X9QvGCPmRtretUubbFl4jr+N8tiktkP6uPv+H0urd7WnH6nU97VvS+h/j82V9m+O6fHfa709tShuo8sa0a9f3p43e3HSo4yKfjXsc6gQcia8k9+p/H9Ar8APvgm1sSvKQ/v6kXjEfvR5pWc/0p0VKP5bkmCXfnZBkQ3//1UkuuhPru3c/6M5M+9G4n5x996T0uxOzaa9M8vSjuS4s2eaxSe7R3z+8NzrHH0h5H4Lyek6S3z0I2zkpSenvn5Hk9WtYzw1J/usalv9EkvuuoW599vhP8uVJ3rOGctmU5JS9fL/X9afdsbz4LtpnT0/ymv5+xfE0yqK/PzfJb6+yjs+2B3trm9Y5rbcutlV3tszWUj8OpD6l/aDi8/aW3lWWfXLaY79lf5c9Gl+zY3ND2p3H71jHdd7pMj4U55+DlbdV1jOOl0+NduxgnVPWmP+vTAvCX5r2WNTrZun/7z1P70x7ZPxFffqj0i4atqWNLLzfwjo3zdZxa/97j76O8RjpN/b28u/mZbSw7HN6u3BW2kicv00LXF2a5BdX2Qcv799fmHbT6FfTbhweszDv0n2ThX7bfL7x3Sxdt87mOzftguvWJL+yuK6er1/rZfzeJF/Qp5+S9ujHB3u6//Ag7fdjkzygv394Wl/id/ZyfKza1z8aX7mT5/VDkK7fSfLcuyq/2b82/g1JHn8Q8vzl/fh/W5KzDiBP41x4blr7fEB1OAfxnJZVrqUOZl07El6HPAFH4qsfSBf1E85z7qJtbEob6nZR2uilF6xXWtYr/UmelRaZ/s5Vvj8zrbPygX7S/qp9rO8RaXe2ru1p++MkJ/Xv/jQtavwLC8t8tpNwtNaFJdu8d+9MfKB3fJ58IOV9iMrrOTk4gaKvn5XP29M7jPu5jif0E97fJvmZNSz/EweYh/83P/7THjG6NMk3r6FcNmWVQNGdWX/uokBRWsdsY9oz73c4ntJ+A+yitDvAb0xy6irreWXaRcZe26Z1Suuv9DTtmbdVd7bM1lo/DiDdY5Tph/eW3lWW/d20O8OX7u+yR+Mr7R9djGPzJelB6TWu8ydndf9OlfGhOP8crLwtWcdnj5csCXQc6jzeReW2anu7j7b8TrWXs/nHxd3XHeo8z9J0h/2aFsz6WJJ/v79lcojycO+0i93bM/221x32RRbO9Yc63QexfParnh6kNP1S308PuAvWfafbwbRHlT6W5M8OQp4/2/fL/geK1vVceDDPaVnlWspr5WvccQcAADji9H9Ec1at9bp9zQvAvgkUAQAAAJDEfz0DAAAAoBMoAgAAACCJQBEAAAAAnUARAAAAAEkEigAAAADo/n8b41ec1TwdRQAAAABJRU5ErkJggg==\n",
      "text/plain": [
       "<Figure size 1440x576 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "# plotting simple histogram of no of players vs countries\n",
    "plt.figure(figsize=(20, 8))\n",
    "plt.hist(fifa['Nationality'], bins=countries)\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 115,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "['Argentina',\n",
       " 'Brazil',\n",
       " 'Spain',\n",
       " 'Germany',\n",
       " 'France',\n",
       " 'England',\n",
       " 'Italy',\n",
       " 'Colombia']"
      ]
     },
     "execution_count": 115,
     "metadata": {},
     "output_type": "execute_result"
    }
   ],
   "source": [
    "#updating list by removing countries with less tha 500 players\n",
    "countries = [x for x in countries if (fifa['Nationality'] == x).sum()>500]\n",
    "countries"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 116,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 1296x432 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "plt.figure(figsize=(18, 6))\n",
    "plt.hist(fifa['Nationality'], range=(1200, 1400), bins=countries)\n",
    "\n",
    "plt.xlabel('Countries')\n",
    "plt.ylabel('No. of Players')\n",
    "plt.title('Countries with maximum number of players')\n",
    "\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "### Pie Chart"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 128,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "iVBORw0KGgoAAAANSUhEUgAAAR4AAAEuCAYAAABYs317AAAAOXRFWHRTb2Z0d2FyZQBNYXRwbG90bGliIHZlcnNpb24zLjMuMywgaHR0cHM6Ly9tYXRwbG90bGliLm9yZy/Il7ecAAAACXBIWXMAAAsTAAALEwEAmpwYAAAkQElEQVR4nO3dd5hU5d3/8fd3C+wuZahS1VFMLGAEC+RRUWwxsjESEzWYREksqcb8fKLuozE5T6JmE2PUaNDEaFAhlqixbTRRI4INoz9RUSMLskgTZYFhC2yb+/njPqvDsn1nzn3OzPd1XXMxzJnymfbZ+5w5RYwxKKVUkPJcB1BK5R4tHqVU4LR4lFKB0+JRSgVOi0cpFTgtHqVU4LR4QkhErhSRTSLygessmSAiR4hIpYjUisgs13k6IyILReRc1zmyTdYVj4hUich2/0Pdehrbx/s0IrJPJ9PniEiL/1jbRGSpiHyhl4+1B/DfwAHGmNG9zRxyPwduMsYMNMY81HZiR++hiMT996LAv948EWlsc70z/GkiIu+JyNtdhWnzeBv9+x2Y7ietPpF1xeM72f9Qt57WB/CYLxpjBgJDgNuA+0RkaNsrtX5pOrEHUG2M+bCnAfwvWxTe0z2Bt7q4Tnffw1+3ud69/uVHAbsBe4vIYd3IdLL//h0MHAr8pDtPJBO68RmJvCh8SNNCRPqLyPUist4/XS8i/VOmnyciK0Rks4g80jpKEpFF/lVeT/2L2hFjTBK4HSgGJoiIJyL3i8h8EdkGzBGRmIjcJiIbRGSdP2uVLyLHA08CY/3Hmudn+KyIvCAiW0XkdRGZkZJ7oYhcJSLPA/XYL9p+IvKk/1zeFZHTU64/T0R+LyIVIlIjIktEZELK9Ikpt90oIpf5l+eJSJmIrBSRahG5T0SGdfJ6d/R6rgT2Bh71n2P/ju6jj84GHgb+7p/vFmPMOuBxYFLbaSIyQUT+5T//TSKyQESG+NMuFpEH2lz/dyJyg3++3ffcnzZHRJ4XketEpBrwRGQfEXlWRBL+Y93bNk+kGWOy6gRUAce3c/nPgZewfwVHAi8Av/CnHQtswv616w/cCCxKua0B9unkMecAz/nnC4ALgRogBnhAEzALW/TFwN+APwAD/DwvA9/2bz8DWJty3+OAamCmf/sT/P+P9KcvBN4HJvqPHQPWAN/0/z/Ff24H+Nef599+qj99AXCPP20QsAE7q1fk/3+aP+1C//Ub779GfwDu7uD16Or1bPc96sZ7GPffi4KU53JlO9crAbb5r9mX/Sz9uvN4wO7Y0VjrZ2MhcK5/fh//9e+P/QwtAq73p40B6oAhKZ+DD4FD/P939p7PAZqBC/zbFQN3A5f773kRcKTr71Zav6euA6T9CdkPUS2w1T895F++EpiZcr0TgSr//G3YIXvrtIHYsoj7/+9O8TT7j7fJ/4K2fpC9Nl+6UUADUJxy2WzgGf/8DHYunkuBu9o83j+As/3zC4Gfp0w7A1jc5vp/AH7mn58H/Cll2kzgPyk5XuvgOb4DHJfy/zH+a1TQznW7ej2r6Lp42nsP4+xaPDtSrrfJv/zrwEf+l7gISABf6ubjrQbmtr4/pBRPO7eblfp6YUdK5/nnvwC83c33fA7wfpv7vhP4IzDe9XcqE6dsnZecZYx5qs1lY7Efqlar/ctap/3/1gnGmFp/yDsO+6HsjpeMMUd2MG1Nyvk9gUJgg4i0XpbX5jq0uf5pInJyymWFwDOd3P80EdmaclkBcFfK/1N/LavHFgPYv/YrO8nxNxFJplzWgv1SrWtz3XS8nu29h+35jTGm7fKYs4H7jDHNQLM/C3Q2dtTR68cTkVHADcB07GgwD9iScpU7gO8Ct2LLr/U178573vb9vwT4BfCyiGwBrjXG3N5ZvijJ1uJpz3p2Xqi5h39Z6jQARGQAMJxdv1C9lboLgDXYv34j/C9GV9ZgRzzn9eD+nzXGnNDzmKwBvtrJtG8ZY57vxv1k+vXskIiMx87qTRWRL/sXlwBFIjLCGLOpD3d/Nfa1PtAYs1nsqgA3pUx/CLhZRCZhRzyX+Jd35z3faTcRxpgPgPP853Qk8JSILDLGrOhD/tDImYXL2Hnmn4jISBEZAfwUmJ8y7ZsiMtlf2Hk1sMQYU+VP34hdINpnxpgNwD+Ba0VksL/QdoKIHN3BTeYDJ4vIif4C6CIRmeF/wdrzGPBpEfmGiBT6p8NEZP9uxHsMGCMiPxK7MH6QiEzzp90CXCUiewL4r+MpHdxPV69nJn0DWA7sC0z2T58G1mJnb/piEHaWLCEi44CLUycaY3YA9wN/AV42xrzvX97T9xwROS3lPd6CLaZkR9ePmlwqniuBV4A3gDexswJXAvhD7CuAB7ALVyew819+D7jD/1XpdPruLKAf8Db2Q3U/dpnJLowxa4BTgMuwyy3WYD/w7b53xpga4HN+/vXY2apfYReIdsq/7QnAyf7tKoFj/Mk3AI8A/xSRGuxyrGkd3E9Xr2cmnQ3MNcZ8kHrCFme3f93qwP9iF5gngArgwXaucwdwIDvP2kIP3nPfYcASEanFvu4XGmPe61P6EBF/QZZSKg3ErgD6H2C0MWab6zxhlUsjHqUySuzKmxdhV0/Q0ulELi1cVipj/AXoG7G/ln7ecZzQ01ktpVTgdFZLKRU4LR6lVOC0eJRSgdPiUUoFTotHKRU4LR6lVOC0eJRSgdPiUUoFTotHKRU4LR6lVOC0eJRSgdPiUUoFTotHKRU4LR6lVOC0eJRSgdPiUUoFTotHKRU4LR6lVOC0eJRSgdPiUUoFTotHKRU4LR6lVOC0eJRSgdPiUUoFTotHKRU4LR6lVOC0eJRSgdPiUUoFTotHKRW4AtcBVEh4sWJg9zan4UAJUOyfStr8mwds90/1KafW/28DPgDWA+vnNx/3/k+az9lYVV6aDO6JqTDS4sklXqwEmAh8BpgETGDnksmoDWb4c8DUeFnFauA9YBVQCbwCvFpVXlqX6QwqHLR4spUtmUOAQ/3TIcCncDh7XWnGDQD6+Tk+1WZyMl5W8Q7wMvBv/983qspLm4JNqYIgxhjXGVQ6eLE8bMGc4J/+C/slD43jGq55f6UZt0cPbtIAvI4toWeBf1SVl9ZkJJwKlBZPlHmxvfmkaI4FhroN1DFjMPs23NHYSGH/PtxNI/AM8AjwSFV56dr0pFNB0+KJGi+2F3AmMBu7vCYSkkY+2rthwcg03+1rwMPYEnotzfetMkiLJwq82G7AGdjC+azjNL1SZ4remdhw+/4ZfIg1wEPArVXlpW9m8HFUGmjxhJX9efsrwNeA44j4DwFrkiOXTG+8YVpAD/cCcAtwX1V5aUNAj6l6QIsnbLzYWOD7wPnACMdp0ual5P7PfrXxiqMDfthqYB5wS1V56YqAH1t1QosnLLzYIcD/A04HCh2nSbu7m4959n+azwu6eFoZ4GnsKOjhqvLSZkc5lC/Sw/fIsz+Bz8IWzpFuw2RWpRnvskwFON4/rYuXVZQDf6wqL210mCmn6YjHBVs4s4GfseuKdFnpG41lyxYnPzPJdY4Uq4GfA3dUlZe2uA6Ta7R4gubFTsV+4CPzU3g6HLHjhg3rGDnGdY52LAc84J6q8lL9MgREiycoXmw68BtgqusoQTOGlgkN80mSl+86SyfeBK6oKi992HWQXKDFk2lebF/gV8AprqO40mzy1u/TMH+s6xzd9G+grKq89F+ug2QzLZ5M8WJFwBXAxWThr1Q9kTAlbx7U8KcDXefooTuBi6rKS6tdB8lGuiOwTPBixwBvAJeR46UDsMnEorhh51nAO/GyijNdB8lG+nN6OnmxYdjlON90HSVM1pqRUf3ZeiSwIF5W8XXgO1Xlpe+7DpQtdMSTLl7sTOAdtHR2sdKMFdcZ+ugk4K14WcWF8bIK/c6kgb6IfeXFRuLFHgMWALu5jhNGlWZcsesMaTAQuB54MV5WEbXlVaGjxdMXXuwoYClQ6jhJqFUmxw9ynSGNpgKvxMsqvuc6SJTpr1q9Ydc8vhy75nGY100JhUN23LypmljWbPCaYj7w7ary0nrXQaJGRzw95cVGAf/Arn2spdMFY9iRpaUD8HVgSbysIic2e0knLZ6e8GLHYmetjnecJDKayN/oOkOGTcLOen3JdZAo0eLpLi/2Y+BJYLTrKFFSQ8lm1xkCMBh4MF5WcU28rCLto2ARqe3BdUeKyBIReU1EpotIKJdFafF0xYvl48XmAtegr1ePfWiG5tKxsn4MPB0vqxjlMMNxwJvGmCnY3cFq8USOFxuA3Zn4d11Hiar3zW65ttOto4F/x8sq9s3kg4jIBBF5QkReFZHFIrKfiEwGfg2cIiJLsdsIThCRpSJyTSbz9JQWT0e82BhgEfpTeZ+sMONycQH87sDieFnFwRl8jD8CFxhjDsGOtOYaY5YCPwXuNcZMBi4FVhpjJhtjLs5glh7T4mmPF5sIvARk8oOTE5Ynx2fDyoO9MRJ4Jl5WMT3ddywiA4HDgb/6I5s/AGHc11GHtHja8mJHA88DPTniperACjN2iOsMDg0G/hEvq5iZ5vvNA7b6I5nWUyYPHZR2WjypvNhxwONAzHWUbLHajMr1zUiKgYfiZRWz03WHxphtwCoROQ1ArIPauWoNEMq1xrV4WnmxzwGPYj8oKg2MYVstJYNd5wiBQmB+vKyitz9SlIjI2pTTRdjjrZ0jIq8Db9HOjuaMMdXA8yKyLGwLl3WTCWgtnYeBItdRsskOU1i5X8Mdulbvzi6rKi/9pesQrumIx4vNwB76VksnzbYyMOE6QwhdHS+ruMh1CNdyu3i82OHo7FXGfGCGbXedIaR+Ey+rOMt1CJdyt3i82GeAv2P3s6IyoMqMSrrOEFIC3BYvq/iC6yCu5Gbx2JUDH0N/vcqoyuT4XFx5sLsKgPviZRVHuA7iQu4VjxcrAR7Brl2qMqjSjBvgOkPIFQMP5+JuNXKreLyYAHcBh7qOkgtWmrHDXGeIgOHA3+NlFdm6z6J25VbxQDlwqusQucAYzFoz0uVW2lGyD3bkkzO/rOZO8Xixc4BLXMfIFQbZ1EC/nPkipcHhwK2uQwQlN4rHbn91s+sYuWQ7/Te5zhBBX4+XVeTE4ZGyv3i82AjgbvSInoHabAZuc50hom6Kl1VEaoPP3sju4rELk+cRsV0GZIP1jNjhOkNElQD3ZvvynuwuHrgQ3ZGXE6uS2vV9cCBwg+sQmZS9xePFpmB3/agcWG7G66xt35wfL6s43XWITMnO4rH7Sr4b6Oc6Sq6qNONCuR+YiLk1Xlaxt+sQmZCdxQM3Ahnd2bbq3CozZrjrDFlgMHZ5T9b9Ac2+4vFis4Cc+EkyrIyhZb0ZrisPpseh2ENlZ5XsKh4vNgg72lEOtZC3MUmebiCaPhfHyyr2cx0inbKreOzxzMe7DpHr6iiqdp0hyxQCv3cdIp2yp3i82GTgAtcxFFSbWI3rDFno2HTuMN617CgeL5aHPbaQDu9DYI0Z2eQ6Q5a6Nl5WkRU7z8+O4oFvA1Ndh1DWSjPWdYRsNQa7OCHyol88XmwUcLXrGOoTlWZcVq/u79gP4mUV7R1DK1KiXzx2HztDXIdQn1iRHJcVswMhlQ/MjZdViOsgfRHt4vFik4Cc3lt/GK0yo0e6zpDlDgfmuA7RF9EuHjuLFfXnkFWMYccmhuTUbjwd8eJlFZHdHi66X1p7TKyTXcdQO2sif6PrDDliDyI82o9u8cCVrgOoXdVQstl1hhxyWbysosB1iN6IZvHYXZke4zqG2tWHZki96ww5ZG/gTNcheiOSbQl4rgOo9r1vRgWy8mDzto/YVPFbknVbAWHg5BMZfOgpbF10F/UrloAI+SVDGD7zRxQM2nVD+Y33/ZSG9e9SNP4AdvvKJ9tgbl/9OlufuR3T0kS/0fsw/KQLkbx86t59nsTiBeQVD2TkqT8hv3gwTVs2sHXRnYw85dIgnnJHLouXVcyvKi+N1FFbo1c8XuwoYIbrGKp9K8zYYNYez8tn6DHn0H/0PiQb6tlwx48oik9h8LQvM+SobwCw7ZVHSLxwN8NP/MEuNx889VRMcwO1S5/4+DJjklRXXMeor15F4bBxbF08n9o3n2bQQZ+j5tVHGX32b6lf/iJ1bz/L4ENOZuviuxgy/euBPN1O7AucDtzjOkhPRHFW60euA6iOVSbHFwfxOAUDh9F/9D4A5PUvoXD47rTUVJPXv+Tj65imHdjDlO+qOD6ZvH47R01ur0HyCygcNg6Aovhk6pc/bydKHqalGdPUgOTls2PNMvIHDP34uo5dHrX1eqJVPF5sD+CLrmOojq0wY4cE/ZjNiY00bnyP/mPtvt+2LLqTtXPnUPf2wh6NSPKKB2OSLTRsqASg/t3nadlmj9IT++xpfHjP5WxfsYQBBxxN4oV7iR3+1fQ/md6ZBHzJdYieiNqs1vfQDUFDrcqM3i3Ix0s2buejv13NsOPO+3i0M/Sosxh61FkkXryPmlcfY8j0r3XrvkSEkV+8hC3/uhXT0kRR/GDIs3+bi/eaQvFeUwCoXfY0xXsfSvPmdWx++UHyigYy9PjzySt0uqXI5cCDLgP0RHRGPF6sCDjXdQzVMWPYVktJYJtLmJZmPvrb1Qw4YAYl+x6+y/QBE2d8MqvUTf3H7c/or/2aMWddR9HuEykcuvOsVLJph13uc3ApW59bwPDSi+g/fiJ1by3sy1NJh4PjZRWHug7RXdEpHvuzoe7HN8QaKPwwqMcyxlD9+A0UDt+dwVM/mcto2rzu4/P1lUsoHNaz/cK11G2199/cxLYl9zNwykk7Td+25EEGH3Iykl+AaW60i5BEMM0NvX4uafQt1wG6S4wxrjN0jxd7DZjsOobq2EYz5JVpDXMD+au7Y+1bbFxwKYUj4yB2uerQo86i9o0nadq8FiSPgsEjGXbi9ykYNIKGDZXULn2c4Sf9EIAPFlxCU/VaTNMO8ooGMfykH1K89yFseeZ26le8DBgGTZ7J4MNO+fgxm2uq2fzEjex2mgdA3X+eI/HcX8grGmB/Yi+JBfHUO7MVGFNVXhr6gylGo3i82JHAYtcxVOeWJicsntX4i+muc+S4M6vKS+92HaIrUZnV0mU7EbDajGpxnUFFY3Yr/MXjxfoDs1zHUF2rTI6L2q+k2ejYeFnFHq5DdCX8xQMnAs5nnlXXKs34ga4zKPKIwL56olA8Z7gOoLpnhRk71HUGBcCcsK/JHO7i8WLF6JrKkbHWjNSjh4bDXoR8e8ZwFw/MBHT4HgFJI5sa6Kc7eQ+PWa4DdCbsxaOzWRGxnX6bXGdQO/m86wCdCW/xeLESoNR1DNU9m82ghOsMaiefjpdV7OU6REfCWzx2HrWkqyupcFjPiNCvLZuDQjvqCXPxHOs6gOq+VcnREVgFPuec6DpAR8JcPLpP5QipNOP7u86gdnFsWA+BE87i8WJD0Q1CI2W5rjwYRoOAI1yHaE84i8cu3wlrNtWOVWaM7rIknEK5nCesX25dvhMhxtCy3gzXlQfDSYunB3T5ToS0kPdhkjzdJW04HRQvqxjmOkRb4SseL7YbMNF1DNV9dRTpyoPhNtl1gLbCVzww1XUA1TPVJlbjOoPq1EGuA7QVxuKZ4jqA6pm1ZkQgRw9VvabF0w1aPBGz0owN9S4YlM5qdYcWT8Qs15UHw27/sK1IGK7i8WKDgLjrGKpnViTHBXYsLdUr/YD9XYdIFa7iCdmLo7pnlRk9wnUG1aXJrgOkClvxHOA6gOoZY9ixiZgWT/iFagGzFo/qkybyN358RD0VZlo8nQjtjotU+2oo2ew6g+qWfVwHSBW24hnrOoDqmY/MkDrXGVS3hGpbOi0e1SerzW569NBoKIqXVYTm+HRhK54xrgOonllhxoXtM6Q6Ntp1gFbh+dB4seGArogWMZXJ8cWuM6huC83sVniKR2ezImmlGRua4bvqko542qHFE0FVZlRo/oqqLoXmvdLiUb1mDNtqGKCbS0SHjnjaMcR1ANUzDRR+6DqD6hEd8bRDFyxHTIIBW11nUD2iI5529HMdQPXMB2bYdtcZVI+E5hBEYSoeHfFETJUZlXSdQfVIgesArcJUPDriiZjK5Hg9skS0aPG0Q0c8EVNpxg1wnUH1SGiKJzRB0BFP5DRSmDeG6o2uc6juMRCao4GEqXh0xBMxf+53Taj28aK6tAHOcp0BCNesllIqs0KzJ4EwFU+t6wBKZTktnnaEZv5TqSylxdMOLR6lMis0e4sMU/HorJZSmbXJdYBWYSoeHfEolVnVrgO00uJRKnfoiKcdOqulVGbpiKcdW10HUCrL6YinHWtdB1Aqy+mIpx0bgGbXIZTKYjri2YWXSALrXcdQKottcB2gVXiKx3rfdQClslQNXkKLpwPvuQ6gVJZ613WAVGErnhWuAyiVpbR4OrHSdQClspQWTyeWuw6gVJbS4unEMqDJdQilspAWT4e8xA7gLdcxlMoyBqh0HSJVuIrHesV1AKWyzHt4iXrXIVJp8SiV/V5wHaAtLR6lst/zrgO0FcbieRNocB1CqSyixdMlL9GILR+lVN8lCOEPNuErHmuJ6wBKZYkX8RLGdYi2wlo8T7kOoFSWCN1sFoS3eJ5GVyRUKh20eLrNS9QAz7mOoVTE7SCkiy3CWTzWE64DKBVxz4RtxcFWYS6ex10HUCriHnMdoCPhLR4v8SawznUMpSJMi6eXdHZLqd5ZipcI7a6Ew148oW1spULuAdcBOhP24vk7sMV1CKUiSIun1+zmE/e6jqFUxLyDl3jHdYjOhLt4rDtdB1AqYv7iOkBXwl88XuJFQrb3NKVCrAW43XWIroS/eKz5rgMoFREVeInQH5E3KsVzF3a/sc69u6mFybfUfnwa/MttXP+S3X3QjUsa2e+mWibOreWSJ3e0e/vrXmxg4txaJs2tZfYD9exotk/rppcb2ed3Ncj/bmNTffLj6z/wdhMT59Yy/c91VPuXr9yc5Iz7Q7lCqnLvVtcBukOMCcX3uWtebBEw3XWMVC1Jw7jf1rLk3AG8tyXJVYsbqDizhP4Fwod1SXYbsHOvr9uW5Mg/1/H29wZSXCic/td6Zn6qgDmT+/HahhaGFgsz5tXxyvkDGFFibztjXh1//1oJD77TxJbtcMG0fsx+oJ6fz+jPp4bnu3jaKrzWAnG8RIvrIF2JyogHQtjkT69qYcKwPPYcksfNrzRSdmR/+hcIwC6l06o5CduboTlpqG+CsYPs9aaMySc+ZNfb5Ak0NEN9ExTmw+LVzYwekKelo9pzexRKB6JVPPcCH7gOkeqeZU3MnlQIwPLqJItXNzPtT7UcPa+Of6/b9f0fNziPH/9XP/a4roYx19YSK4LPTSjo9DH+58j+HH9XHY8ub2b2pEJ+saiBK47un5HnoyItCdzmOkR3Rad47Do9v3cdo1Vji+GRd5s57QBbHM1J2Lzd8NI5A7jmhCJOv7+etrOxW7YbHn63mVUXDmT9RQOpa4T5bzR2+jgnTCjg1fMH8ujsEh5+t4mZnypgeXULX7mvnvMe2U59U0RmlVWmPRHmTSTaik7xWLdg9zHi3OOVzRw8Jo9RA+1LOH6wcOr+hYgIU8flkyewqX7nUnjqvWb2GpLHyAF5FOYLp+5fwAtrujcyrm8yzFvaxPcP68fPFjZwx6xijtwjnwVv6P7SFAC/dh2gJ6JVPF5iEzDPdQyAu1NmswBm7VfIM1XNACyvbqGxBUaUyE632SMmvLSuhfomgzGGp1e1sP+I7i2rueb5Rn44rR+F+cL2JhCxy390xKOAxXiJZ12H6IloFY91DXYlKWfqGg1PvtfCqft/UjzfmlLIe1sMk+bW8tX7t3PHrGJEhPU1SWYusD99TxtfwFf2L+DgP9Rx4M11JA2cf4i9j98taWD8b2tYu83wmZvrOPeR7R/f9/qaJC+vb2HWfva6F0ztx2G31nHLq02ceWAhKudd6TpAT0Xn5/RUXuwvwGzXMZQKgZfxEtNch+ipKI54AH5JSFYoVMqxyI12IKrFY/dOGPoN4ZTKsKV4iUddh+iNaBaPdTl6qGOV265yHaC3ols8XmI1cKPrGEo58goh39lXZ6JbPNZVwGbXIZQKmAF+GMZDE3dXtIvHS2wlogvXlOqD+f5+qiIr2sVj/R5Y5TqEUgGpBS51HaKvol88dhuu/3EdQ6mAXIWX2OA6RF9Fv3gAvMS9wD9cx1Aqw1YA17kOkQ7ZUTzWt7HDUKWy1UV4iaxYhSR7isf+vF7mOoZSGfJwVFcWbE/2FI81F1jsOoRSabYZ+I7rEOmUXcVj12s4l5Dss0epNLkALxGqvW/2VXYVD4CXWA78zHUMpdLkQbxE1m2XmH3FY10L/Nt1CKX6aANwvusQmZCdxWP3tH8GsNVxEqV6ywBz8BLVroNkQnYWD4CXWAWche63R0XT7/AS/3QdIlOyt3gA/+fHa1zHUKqHXgAucR0ik7K7eKzLgEjtCFvltPXAl/1NgbJWNPe53FNebDTwGjDadRSlOtEAHIWXeNl1kEzLhREP/joQs3F8dAqluvCdXCgdyJXiAfASC4Efu46hVAduxEvMcx0iKLlTPABe4np0d6kqfBYCF7kOEaTcKh7rR8AjrkMo5XsXOA0v0ew6SJByY+FyW16sBHga+KzrKCqnvQ8ciZdY4zpI0HKzeAC82DDsluwHuI6ictJGYDpeotJ1EBdycVbL8hKbgROBnPtro5zbAnwuV0sHHBSPiLSIyFIRWSYij4rIEP/ysSJyfzdu3+5eBkVkloj0bPTiJdYCJ2BX2lIqCHXATLzEG66DuORixLPdGDPZGDMJu4Oj7wMYY9YbY77Sh/udRW9mm7zEu8BR2PltpTKpATgFL/GS6yCuuZ7VehEYByAicRFZ5p8vEZH7RORtEfmbiCwRkUNbbyQiV4nI6yLykoiMEpHDgS8C1/ijqQk9SuElVgLTgZXpemJKtbEduynE066DhIGz4hGRfOA42v9p+3vAFmPMAcAVwCEp0wYALxljDgIWAecZY17w7+difzTV8wLxEu9jRz7v9Pi2SnVuK3aZToXrIGHhoniKRWQp8AEwCniynescCdwDYIxZBqTODzcCj/nnXwXiaUvmJdYDRwOvp+0+Va7bgN3+6jnXQcLE2TIeYE9A8Jfx9ECT+WQdgBagII3ZwEt8BByD7sFQ9d0K4Ai8xJuug4SNs1ktY0w98EPgv0WkbXk8D5wO4P9SdWA37rIGGJSWcF5iC3As8HBa7k/lotewpaOH126H04XLxpjXsLNRs9tMmguMFJG3gSuBt4BEF3d3D3CxiLzW44XL7fEStcCXgF/2+b5UrlkIzMBLfOg6SFiFcs1lf8FzoTFmh18iTwH7GmPc7BzJi30N+BNQ5OTxVZTcDFyIl2hyHSTMwlo8g4BngELscqBLjTGPOw3lxaYBD6E7E1PtawR+gJe41XWQKAhl8YSWFxuPXe5zsOsoKlTWYbcwf9F1kKhwvQJhtNhNLKYD+ldNtXoKmKKl0zM64uktLzYLW0AjHCdRbiSBqwAPL5F0HSZqtHj6wouNAf6M3cpd5Y4VwDd1pcDe01mtvvASG4CTsHs13OE2jAqAAX4HHKSl0zc64kkXLzYJWAB8xnUUlRErgW/hJRa5DpINdMSTLl5iGXAY8BPslsgqOxjgJuwoR0snTXTEkwlebG/sh/Uk11FUn7yFXTdnoesg2UaLJ5O82KnAtaRzC3oVhI+AnwK34iX0IJAZoMWTaV6sCLgYKANKHKdRnWsEbgCuwkt0tW2g6gMtnqB4sXHA5cA5QD/HadSuHgAuwUu85zpILtDiCZoX2x24DPgWWkBh8CzwU11wHCwtHle82B58UkCFjtPkGgM8CpTrpg5uaPG45sX2xBbQHHQElGnNwN3Ar/ASb7kOk8u0eMLCi43Ejn6+DezlOE222Q7cBvwGL7HadRilxRM+XiwP+DzwXWAmupJnXywD/gjM93dnq0JCiyfM7GzY+cC5wG6O00RFAvgrcJseOC+8tHiiwIsVADOAL2P3Az3KaZ7waQb+CdwJPIyX0A12Q06LJ2rsrNiR2BI6FRjvNpAz1cDj2GOsPaEr/EWLFk+UeTEBpmKPG388dpes2bxMaBm2aB4DXtQdcEWXFk828WJDsEdCnQEcAUwh3Qc8DE4z9tBHLwFLgGf1F6nsocWTzbxYCXZENA2Y6J/2I5zbjK3BFkxr0byKl9Ddi2QpLZ5cY2fP4tgSOsA/7Yc9bM8oMnfsMIM9GsMK7E61Vux03kvUZOhxVQhp8aidebFB2AIahf0JfxQwEugP5GNn3fLbOb8Dexjp1tNWYBN2IXA1sF5/bVKttHiUUoHL5l9AlFIhpcWjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUCp8WjlAqcFo9SKnBaPEqpwGnxKKUC939O9B/1aHQ2zgAAAABJRU5ErkJggg==\n",
      "text/plain": [
       "<Figure size 576x360 with 1 Axes>"
      ]
     },
     "metadata": {},
     "output_type": "display_data"
    }
   ],
   "source": [
    "left = (fifa['Preferred Foot'] == 'Left').sum()\n",
    "right = (fifa['Preferred Foot'] == 'Right').sum()\n",
    "\n",
    "plt.figure(figsize=(8,5))\n",
    "\n",
    "labels = ['Left', 'Right']\n",
    "\n",
    "plt.pie([left, right], labels = labels, autopct='%.2f%%')\n",
    "\n",
    "plt.title('Foot Preference of FIFA Players')\n",
    "\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "metadata": {},
   "outputs": [],
   "source": []
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "metadata": {},
   "outputs": [],
   "source": []
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "metadata": {},
   "outputs": [],
   "source": []
  }
 ],
 "metadata": {
  "kernelspec": {
   "display_name": "Python 3",
   "language": "python",
   "name": "python3"
  },
  "language_info": {
   "codemirror_mode": {
    "name": "ipython",
    "version": 3
   },
   "file_extension": ".py",
   "mimetype": "text/x-python",
   "name": "python",
   "nbconvert_exporter": "python",
   "pygments_lexer": "ipython3",
   "version": "3.9.1"
  }
 },
 "nbformat": 4,
 "nbformat_minor": 4
}
